// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.serde

import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.LicenseManagerLinuxSubscriptionsException
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscovery
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.LinuxSubscriptionsDiscoverySettings
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.Status
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.UpdateServiceSettingsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateServiceSettingsOperationDeserializer: HttpDeserializer.NonStreaming<UpdateServiceSettingsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateServiceSettingsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateServiceSettingsError(context, call, payload)
        }
        val builder = UpdateServiceSettingsResponse.Builder()

        if (payload != null) {
            deserializeUpdateServiceSettingsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateServiceSettingsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerLinuxSubscriptionsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> LicenseManagerLinuxSubscriptionsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateServiceSettingsOperationBody(builder: UpdateServiceSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HOMEREGIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HomeRegions"))
    val LINUXSUBSCRIPTIONSDISCOVERY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LinuxSubscriptionsDiscovery"))
    val LINUXSUBSCRIPTIONSDISCOVERYSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LinuxSubscriptionsDiscoverySettings"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("StatusMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HOMEREGIONS_DESCRIPTOR)
        field(LINUXSUBSCRIPTIONSDISCOVERY_DESCRIPTOR)
        field(LINUXSUBSCRIPTIONSDISCOVERYSETTINGS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOMEREGIONS_DESCRIPTOR.index -> builder.homeRegions =
                    deserializer.deserializeList(HOMEREGIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LINUXSUBSCRIPTIONSDISCOVERY_DESCRIPTOR.index -> builder.linuxSubscriptionsDiscovery = deserializeString().let { LinuxSubscriptionsDiscovery.fromValue(it) }
                LINUXSUBSCRIPTIONSDISCOVERYSETTINGS_DESCRIPTOR.index -> builder.linuxSubscriptionsDiscoverySettings = deserializeLinuxSubscriptionsDiscoverySettingsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage =
                    deserializer.deserializeMap(STATUSMESSAGE_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
