// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details discovered information about a running instance using Linux subscriptions.
 */
public class Instance private constructor(builder: Builder) {
    /**
     * The account ID which owns the instance.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The AMI ID used to launch the instance.
     */
    public val amiId: kotlin.String? = builder.amiId
    /**
     * Indicates that you have two different license subscriptions for the same software on your instance.
     */
    public val dualSubscription: kotlin.String? = builder.dualSubscription
    /**
     * The instance ID of the resource.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The instance type of the resource.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The time in which the last discovery updated the instance details.
     */
    public val lastUpdatedTime: kotlin.String? = builder.lastUpdatedTime
    /**
     * The operating system software version that runs on your instance.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The product code for the instance. For more information, see [Usage operation values](https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html) in the *License Manager User Guide* .
     */
    public val productCode: List<String>? = builder.productCode
    /**
     * The Region the instance is running in.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Indicates that your instance uses a BYOL license subscription from a third-party Linux subscription provider that you've registered with License Manager.
     */
    public val registeredWithSubscriptionProvider: kotlin.String? = builder.registeredWithSubscriptionProvider
    /**
     * The status of the instance.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The name of the license subscription that the instance uses.
     */
    public val subscriptionName: kotlin.String? = builder.subscriptionName
    /**
     * The timestamp when you registered the third-party Linux subscription provider for the subscription that the instance uses.
     */
    public val subscriptionProviderCreateTime: kotlin.String? = builder.subscriptionProviderCreateTime
    /**
     * The timestamp from the last time that the instance synced with the registered third-party Linux subscription provider.
     */
    public val subscriptionProviderUpdateTime: kotlin.String? = builder.subscriptionProviderUpdateTime
    /**
     * The usage operation of the instance. For more information, see For more information, see [Usage operation values](https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html) in the *License Manager User Guide*.
     */
    public val usageOperation: kotlin.String? = builder.usageOperation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("accountId=$accountId,")
        append("amiId=$amiId,")
        append("dualSubscription=$dualSubscription,")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("osVersion=$osVersion,")
        append("productCode=$productCode,")
        append("region=$region,")
        append("registeredWithSubscriptionProvider=$registeredWithSubscriptionProvider,")
        append("status=$status,")
        append("subscriptionName=$subscriptionName,")
        append("subscriptionProviderCreateTime=$subscriptionProviderCreateTime,")
        append("subscriptionProviderUpdateTime=$subscriptionProviderUpdateTime,")
        append("usageOperation=$usageOperation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (amiId?.hashCode() ?: 0)
        result = 31 * result + (dualSubscription?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (productCode?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (registeredWithSubscriptionProvider?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (subscriptionProviderCreateTime?.hashCode() ?: 0)
        result = 31 * result + (subscriptionProviderUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (usageOperation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (accountId != other.accountId) return false
        if (amiId != other.amiId) return false
        if (dualSubscription != other.dualSubscription) return false
        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (osVersion != other.osVersion) return false
        if (productCode != other.productCode) return false
        if (region != other.region) return false
        if (registeredWithSubscriptionProvider != other.registeredWithSubscriptionProvider) return false
        if (status != other.status) return false
        if (subscriptionName != other.subscriptionName) return false
        if (subscriptionProviderCreateTime != other.subscriptionProviderCreateTime) return false
        if (subscriptionProviderUpdateTime != other.subscriptionProviderUpdateTime) return false
        if (usageOperation != other.usageOperation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.Instance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The account ID which owns the instance.
         */
        public var accountId: kotlin.String? = null
        /**
         * The AMI ID used to launch the instance.
         */
        public var amiId: kotlin.String? = null
        /**
         * Indicates that you have two different license subscriptions for the same software on your instance.
         */
        public var dualSubscription: kotlin.String? = null
        /**
         * The instance ID of the resource.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The instance type of the resource.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The time in which the last discovery updated the instance details.
         */
        public var lastUpdatedTime: kotlin.String? = null
        /**
         * The operating system software version that runs on your instance.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The product code for the instance. For more information, see [Usage operation values](https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html) in the *License Manager User Guide* .
         */
        public var productCode: List<String>? = null
        /**
         * The Region the instance is running in.
         */
        public var region: kotlin.String? = null
        /**
         * Indicates that your instance uses a BYOL license subscription from a third-party Linux subscription provider that you've registered with License Manager.
         */
        public var registeredWithSubscriptionProvider: kotlin.String? = null
        /**
         * The status of the instance.
         */
        public var status: kotlin.String? = null
        /**
         * The name of the license subscription that the instance uses.
         */
        public var subscriptionName: kotlin.String? = null
        /**
         * The timestamp when you registered the third-party Linux subscription provider for the subscription that the instance uses.
         */
        public var subscriptionProviderCreateTime: kotlin.String? = null
        /**
         * The timestamp from the last time that the instance synced with the registered third-party Linux subscription provider.
         */
        public var subscriptionProviderUpdateTime: kotlin.String? = null
        /**
         * The usage operation of the instance. For more information, see For more information, see [Usage operation values](https://docs.aws.amazon.com/license-manager/latest/userguide/linux-subscriptions-usage-operation.html) in the *License Manager User Guide*.
         */
        public var usageOperation: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.Instance) : this() {
            this.accountId = x.accountId
            this.amiId = x.amiId
            this.dualSubscription = x.dualSubscription
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.lastUpdatedTime = x.lastUpdatedTime
            this.osVersion = x.osVersion
            this.productCode = x.productCode
            this.region = x.region
            this.registeredWithSubscriptionProvider = x.registeredWithSubscriptionProvider
            this.status = x.status
            this.subscriptionName = x.subscriptionName
            this.subscriptionProviderCreateTime = x.subscriptionProviderCreateTime
            this.subscriptionProviderUpdateTime = x.subscriptionProviderUpdateTime
            this.usageOperation = x.usageOperation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.Instance = Instance(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
