// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.paginators

import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsClient
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.Instance
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesRequest
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionInstancesResponse
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsRequest
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.ListLinuxSubscriptionsResponse
import aws.sdk.kotlin.services.licensemanagerlinuxsubscriptions.model.Subscription
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListLinuxSubscriptionInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLinuxSubscriptionInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinuxSubscriptionInstancesResponse]
 */
public fun LicenseManagerLinuxSubscriptionsClient.listLinuxSubscriptionInstancesPaginated(initialRequest: ListLinuxSubscriptionInstancesRequest = ListLinuxSubscriptionInstancesRequest { }): Flow<ListLinuxSubscriptionInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLinuxSubscriptionInstancesPaginated.listLinuxSubscriptionInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLinuxSubscriptionInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinuxSubscriptionInstancesResponse]
 */
public fun LicenseManagerLinuxSubscriptionsClient.listLinuxSubscriptionInstancesPaginated(block: ListLinuxSubscriptionInstancesRequest.Builder.() -> Unit): Flow<ListLinuxSubscriptionInstancesResponse> =
    listLinuxSubscriptionInstancesPaginated(ListLinuxSubscriptionInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLinuxSubscriptionInstancesPaginated]
 * to access the nested member [Instance]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Instance]
 */
@JvmName("listLinuxSubscriptionInstancesResponseInstance")
public fun Flow<ListLinuxSubscriptionInstancesResponse>.instances(): Flow<Instance> =
    transform() { response ->
        response.instances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLinuxSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLinuxSubscriptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinuxSubscriptionsResponse]
 */
public fun LicenseManagerLinuxSubscriptionsClient.listLinuxSubscriptionsPaginated(initialRequest: ListLinuxSubscriptionsRequest = ListLinuxSubscriptionsRequest { }): Flow<ListLinuxSubscriptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLinuxSubscriptionsPaginated.listLinuxSubscriptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLinuxSubscriptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinuxSubscriptionsResponse]
 */
public fun LicenseManagerLinuxSubscriptionsClient.listLinuxSubscriptionsPaginated(block: ListLinuxSubscriptionsRequest.Builder.() -> Unit): Flow<ListLinuxSubscriptionsResponse> =
    listLinuxSubscriptionsPaginated(ListLinuxSubscriptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLinuxSubscriptionsPaginated]
 * to access the nested member [Subscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Subscription]
 */
@JvmName("listLinuxSubscriptionsResponseSubscription")
public fun Flow<ListLinuxSubscriptionsResponse>.subscriptions(): Flow<Subscription> =
    transform() { response ->
        response.subscriptions?.forEach {
            emit(it)
        }
    }
