// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.sdk.kotlin.services.licensemanager.model.TagResourceResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class TagResourceOperationDeserializer: HttpDeserialize<TagResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TagResourceResponse {
        if (!response.status.isSuccess()) {
            throwTagResourceError(context, response)
        }
        val builder = TagResourceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwTagResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
