// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.GetServiceSettingsResponse
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.sdk.kotlin.services.licensemanager.model.OrganizationConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetServiceSettingsOperationDeserializer: HttpDeserialize<GetServiceSettingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetServiceSettingsResponse {
        if (!response.status.isSuccess()) {
            throwGetServiceSettingsError(context, response)
        }
        val builder = GetServiceSettingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetServiceSettingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetServiceSettingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetServiceSettingsOperationBody(builder: GetServiceSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENABLECROSSACCOUNTSDISCOVERY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableCrossAccountsDiscovery"))
    val LICENSEMANAGERRESOURCESHAREARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseManagerResourceShareArn"))
    val ORGANIZATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OrganizationConfiguration"))
    val S3BUCKETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketArn"))
    val SNSTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENABLECROSSACCOUNTSDISCOVERY_DESCRIPTOR)
        field(LICENSEMANAGERRESOURCESHAREARN_DESCRIPTOR)
        field(ORGANIZATIONCONFIGURATION_DESCRIPTOR)
        field(S3BUCKETARN_DESCRIPTOR)
        field(SNSTOPICARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENABLECROSSACCOUNTSDISCOVERY_DESCRIPTOR.index -> builder.enableCrossAccountsDiscovery = deserializeBoolean()
                LICENSEMANAGERRESOURCESHAREARN_DESCRIPTOR.index -> builder.licenseManagerResourceShareArn = deserializeString()
                ORGANIZATIONCONFIGURATION_DESCRIPTOR.index -> builder.organizationConfiguration = deserializeOrganizationConfigurationDocument(deserializer)
                S3BUCKETARN_DESCRIPTOR.index -> builder.s3BucketArn = deserializeString()
                SNSTOPICARN_DESCRIPTOR.index -> builder.snsTopicArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
