// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseConversionTaskResponse
import aws.sdk.kotlin.services.licensemanager.model.LicenseConversionContext
import aws.sdk.kotlin.services.licensemanager.model.LicenseConversionTaskStatus
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetLicenseConversionTaskOperationDeserializer: HttpDeserialize<GetLicenseConversionTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLicenseConversionTaskResponse {
        if (!response.status.isSuccess()) {
            throwGetLicenseConversionTaskError(context, response)
        }
        val builder = GetLicenseConversionTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLicenseConversionTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLicenseConversionTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLicenseConversionTaskOperationBody(builder: GetLicenseConversionTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESTINATIONLICENSECONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DestinationLicenseContext"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val LICENSECONVERSIONTASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseConversionTaskId"))
    val LICENSECONVERSIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LicenseConversionTime"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val SOURCELICENSECONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceLicenseContext"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONLICENSECONTEXT_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(LICENSECONVERSIONTASKID_DESCRIPTOR)
        field(LICENSECONVERSIONTIME_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(SOURCELICENSECONTEXT_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESTINATIONLICENSECONTEXT_DESCRIPTOR.index -> builder.destinationLicenseContext = deserializeLicenseConversionContextDocument(deserializer)
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LICENSECONVERSIONTASKID_DESCRIPTOR.index -> builder.licenseConversionTaskId = deserializeString()
                LICENSECONVERSIONTIME_DESCRIPTOR.index -> builder.licenseConversionTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                SOURCELICENSECONTEXT_DESCRIPTOR.index -> builder.sourceLicenseContext = deserializeLicenseConversionContextDocument(deserializer)
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LicenseConversionTaskStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
