// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.AutomatedDiscoveryInformation
import aws.sdk.kotlin.services.licensemanager.model.ConsumedLicenseSummary
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseConfigurationResponse
import aws.sdk.kotlin.services.licensemanager.model.LicenseCountingType
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.sdk.kotlin.services.licensemanager.model.ManagedResourceSummary
import aws.sdk.kotlin.services.licensemanager.model.ProductInformation
import aws.sdk.kotlin.services.licensemanager.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetLicenseConfigurationOperationDeserializer: HttpDeserialize<GetLicenseConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLicenseConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetLicenseConfigurationError(context, response)
        }
        val builder = GetLicenseConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetLicenseConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetLicenseConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetLicenseConfigurationOperationBody(builder: GetLicenseConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOMATEDDISCOVERYINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutomatedDiscoveryInformation"))
    val CONSUMEDLICENSESUMMARYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ConsumedLicenseSummaryList"))
    val CONSUMEDLICENSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ConsumedLicenses"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DISASSOCIATEWHENNOTFOUND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DisassociateWhenNotFound"))
    val LICENSECONFIGURATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseConfigurationArn"))
    val LICENSECONFIGURATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseConfigurationId"))
    val LICENSECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("LicenseCount"))
    val LICENSECOUNTHARDLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("LicenseCountHardLimit"))
    val LICENSECOUNTINGTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseCountingType"))
    val LICENSERULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LicenseRules"))
    val MANAGEDRESOURCESUMMARYLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ManagedResourceSummaryList"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OWNERACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerAccountId"))
    val PRODUCTINFORMATIONLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProductInformationList"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOMATEDDISCOVERYINFORMATION_DESCRIPTOR)
        field(CONSUMEDLICENSESUMMARYLIST_DESCRIPTOR)
        field(CONSUMEDLICENSES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISASSOCIATEWHENNOTFOUND_DESCRIPTOR)
        field(LICENSECONFIGURATIONARN_DESCRIPTOR)
        field(LICENSECONFIGURATIONID_DESCRIPTOR)
        field(LICENSECOUNT_DESCRIPTOR)
        field(LICENSECOUNTHARDLIMIT_DESCRIPTOR)
        field(LICENSECOUNTINGTYPE_DESCRIPTOR)
        field(LICENSERULES_DESCRIPTOR)
        field(MANAGEDRESOURCESUMMARYLIST_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OWNERACCOUNTID_DESCRIPTOR)
        field(PRODUCTINFORMATIONLIST_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOMATEDDISCOVERYINFORMATION_DESCRIPTOR.index -> builder.automatedDiscoveryInformation = deserializeAutomatedDiscoveryInformationDocument(deserializer)
                CONSUMEDLICENSESUMMARYLIST_DESCRIPTOR.index -> builder.consumedLicenseSummaryList =
                    deserializer.deserializeList(CONSUMEDLICENSESUMMARYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ConsumedLicenseSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConsumedLicenseSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONSUMEDLICENSES_DESCRIPTOR.index -> builder.consumedLicenses = deserializeLong()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISASSOCIATEWHENNOTFOUND_DESCRIPTOR.index -> builder.disassociateWhenNotFound = deserializeBoolean()
                LICENSECONFIGURATIONARN_DESCRIPTOR.index -> builder.licenseConfigurationArn = deserializeString()
                LICENSECONFIGURATIONID_DESCRIPTOR.index -> builder.licenseConfigurationId = deserializeString()
                LICENSECOUNT_DESCRIPTOR.index -> builder.licenseCount = deserializeLong()
                LICENSECOUNTHARDLIMIT_DESCRIPTOR.index -> builder.licenseCountHardLimit = deserializeBoolean()
                LICENSECOUNTINGTYPE_DESCRIPTOR.index -> builder.licenseCountingType = deserializeString().let { LicenseCountingType.fromValue(it) }
                LICENSERULES_DESCRIPTOR.index -> builder.licenseRules =
                    deserializer.deserializeList(LICENSERULES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MANAGEDRESOURCESUMMARYLIST_DESCRIPTOR.index -> builder.managedResourceSummaryList =
                    deserializer.deserializeList(MANAGEDRESOURCESUMMARYLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ManagedResourceSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeManagedResourceSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OWNERACCOUNTID_DESCRIPTOR.index -> builder.ownerAccountId = deserializeString()
                PRODUCTINFORMATIONLIST_DESCRIPTOR.index -> builder.productInformationList =
                    deserializer.deserializeList(PRODUCTINFORMATIONLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductInformation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductInformationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
