// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.DeleteLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.LicenseDeletionStatus
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteLicenseOperationDeserializer: HttpDeserialize<DeleteLicenseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteLicenseResponse {
        if (!response.status.isSuccess()) {
            throwDeleteLicenseError(context, response)
        }
        val builder = DeleteLicenseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteLicenseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteLicenseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "RedirectException" -> RedirectExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteLicenseOperationBody(builder: DeleteLicenseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeletionDate"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELETIONDATE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELETIONDATE_DESCRIPTOR.index -> builder.deletionDate = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LicenseDeletionStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
