// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateLicenseManagerReportGeneratorOperationDeserializer: HttpDeserialize<CreateLicenseManagerReportGeneratorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateLicenseManagerReportGeneratorResponse {
        if (!response.status.isSuccess()) {
            throwCreateLicenseManagerReportGeneratorError(context, response)
        }
        val builder = CreateLicenseManagerReportGeneratorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateLicenseManagerReportGeneratorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateLicenseManagerReportGeneratorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateLicenseManagerReportGeneratorOperationBody(builder: CreateLicenseManagerReportGeneratorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LICENSEMANAGERREPORTGENERATORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseManagerReportGeneratorArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LICENSEMANAGERREPORTGENERATORARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LICENSEMANAGERREPORTGENERATORARN_DESCRIPTOR.index -> builder.licenseManagerReportGeneratorArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
