// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.services.licensemanager.model.CheckoutLicenseRequest
import aws.sdk.kotlin.services.licensemanager.model.CheckoutType
import aws.sdk.kotlin.services.licensemanager.model.EntitlementData
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CheckoutLicenseOperationSerializer: HttpSerialize<CheckoutLicenseRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CheckoutLicenseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCheckoutLicenseOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCheckoutLicenseOperationBody(context: ExecutionContext, input: CheckoutLicenseRequest): ByteArray {
    val serializer = JsonSerializer()
    val BENEFICIARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Beneficiary"))
    val CHECKOUTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CheckoutType"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val ENTITLEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Entitlements"))
    val KEYFINGERPRINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyFingerprint"))
    val NODEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NodeId"))
    val PRODUCTSKU_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProductSKU"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BENEFICIARY_DESCRIPTOR)
        field(CHECKOUTTYPE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(ENTITLEMENTS_DESCRIPTOR)
        field(KEYFINGERPRINT_DESCRIPTOR)
        field(NODEID_DESCRIPTOR)
        field(PRODUCTSKU_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.beneficiary?.let { field(BENEFICIARY_DESCRIPTOR, it) }
        input.checkoutType?.let { field(CHECKOUTTYPE_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        if (input.entitlements != null) {
            listField(ENTITLEMENTS_DESCRIPTOR) {
                for (el0 in input.entitlements) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeEntitlementDataDocument))
                }
            }
        }
        input.keyFingerprint?.let { field(KEYFINGERPRINT_DESCRIPTOR, it) }
        input.nodeId?.let { field(NODEID_DESCRIPTOR, it) }
        input.productSku?.let { field(PRODUCTSKU_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
