// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.CheckoutLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.CheckoutType
import aws.sdk.kotlin.services.licensemanager.model.EntitlementData
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CheckoutLicenseOperationDeserializer: HttpDeserialize<CheckoutLicenseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CheckoutLicenseResponse {
        if (!response.status.isSuccess()) {
            throwCheckoutLicenseError(context, response)
        }
        val builder = CheckoutLicenseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCheckoutLicenseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCheckoutLicenseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "NoEntitlementsAllowedException" -> NoEntitlementsAllowedExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "RedirectException" -> RedirectExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedDigitalSignatureMethodException" -> UnsupportedDigitalSignatureMethodExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCheckoutLicenseOperationBody(builder: CheckoutLicenseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHECKOUTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CheckoutType"))
    val ENTITLEMENTSALLOWED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EntitlementsAllowed"))
    val EXPIRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Expiration"))
    val ISSUEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IssuedAt"))
    val LICENSEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseArn"))
    val LICENSECONSUMPTIONTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LicenseConsumptionToken"))
    val NODEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NodeId"))
    val SIGNEDTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SignedToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHECKOUTTYPE_DESCRIPTOR)
        field(ENTITLEMENTSALLOWED_DESCRIPTOR)
        field(EXPIRATION_DESCRIPTOR)
        field(ISSUEDAT_DESCRIPTOR)
        field(LICENSEARN_DESCRIPTOR)
        field(LICENSECONSUMPTIONTOKEN_DESCRIPTOR)
        field(NODEID_DESCRIPTOR)
        field(SIGNEDTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHECKOUTTYPE_DESCRIPTOR.index -> builder.checkoutType = deserializeString().let { CheckoutType.fromValue(it) }
                ENTITLEMENTSALLOWED_DESCRIPTOR.index -> builder.entitlementsAllowed =
                    deserializer.deserializeList(ENTITLEMENTSALLOWED_DESCRIPTOR) {
                        val col0 = mutableListOf<EntitlementData>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEntitlementDataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EXPIRATION_DESCRIPTOR.index -> builder.expiration = deserializeString()
                ISSUEDAT_DESCRIPTOR.index -> builder.issuedAt = deserializeString()
                LICENSEARN_DESCRIPTOR.index -> builder.licenseArn = deserializeString()
                LICENSECONSUMPTIONTOKEN_DESCRIPTOR.index -> builder.licenseConsumptionToken = deserializeString()
                NODEID_DESCRIPTOR.index -> builder.nodeId = deserializeString()
                SIGNEDTOKEN_DESCRIPTOR.index -> builder.signedToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
