// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.licensemanager.model.AcceptGrantResponse
import aws.sdk.kotlin.services.licensemanager.model.GrantStatus
import aws.sdk.kotlin.services.licensemanager.model.LicenseManagerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AcceptGrantOperationDeserializer: HttpDeserialize<AcceptGrantResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AcceptGrantResponse {
        if (!response.status.isSuccess()) {
            throwAcceptGrantError(context, response)
        }
        val builder = AcceptGrantResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAcceptGrantOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAcceptGrantError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LicenseManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationException" -> AuthorizationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "RateLimitExceededException" -> RateLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceededException" -> ResourceLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServerInternalException" -> ServerInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LicenseManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAcceptGrantOperationBody(builder: AcceptGrantResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GRANTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GrantArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GRANTARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GRANTARN_DESCRIPTOR.index -> builder.grantArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { GrantStatus.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
