// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.model



/**
 * Describe the details of a report generator.
 */
public class ReportGenerator private constructor(builder: Builder) {
    /**
     * Time the report was created.
     */
    public val createTime: kotlin.String? = builder.createTime
    /**
     * Description of the report generator.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Time the last report was generated at.
     */
    public val lastReportGenerationTime: kotlin.String? = builder.lastReportGenerationTime
    /**
     * Failure message for the last report generation attempt.
     */
    public val lastRunFailureReason: kotlin.String? = builder.lastRunFailureReason
    /**
     * Status of the last report generation attempt.
     */
    public val lastRunStatus: kotlin.String? = builder.lastRunStatus
    /**
     * Amazon Resource Name (ARN) of the report generator.
     */
    public val licenseManagerReportGeneratorArn: kotlin.String? = builder.licenseManagerReportGeneratorArn
    /**
     * License configuration type for this generator.
     */
    public val reportContext: aws.sdk.kotlin.services.licensemanager.model.ReportContext? = builder.reportContext
    /**
     * The Amazon Web Services account ID used to create the report generator.
     */
    public val reportCreatorAccount: kotlin.String? = builder.reportCreatorAccount
    /**
     * Details about how frequently reports are generated.
     */
    public val reportFrequency: aws.sdk.kotlin.services.licensemanager.model.ReportFrequency? = builder.reportFrequency
    /**
     * Name of the report generator.
     */
    public val reportGeneratorName: kotlin.String? = builder.reportGeneratorName
    /**
     * Type of reports that are generated.
     */
    public val reportType: List<ReportType>? = builder.reportType
    /**
     * Details of the S3 bucket that report generator reports are published to.
     */
    public val s3Location: aws.sdk.kotlin.services.licensemanager.model.S3Location? = builder.s3Location
    /**
     * Tags associated with the report generator.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.licensemanager.model.ReportGenerator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportGenerator(")
        append("createTime=$createTime,")
        append("description=$description,")
        append("lastReportGenerationTime=$lastReportGenerationTime,")
        append("lastRunFailureReason=$lastRunFailureReason,")
        append("lastRunStatus=$lastRunStatus,")
        append("licenseManagerReportGeneratorArn=$licenseManagerReportGeneratorArn,")
        append("reportContext=$reportContext,")
        append("reportCreatorAccount=$reportCreatorAccount,")
        append("reportFrequency=$reportFrequency,")
        append("reportGeneratorName=$reportGeneratorName,")
        append("reportType=$reportType,")
        append("s3Location=$s3Location,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastReportGenerationTime?.hashCode() ?: 0)
        result = 31 * result + (lastRunFailureReason?.hashCode() ?: 0)
        result = 31 * result + (lastRunStatus?.hashCode() ?: 0)
        result = 31 * result + (licenseManagerReportGeneratorArn?.hashCode() ?: 0)
        result = 31 * result + (reportContext?.hashCode() ?: 0)
        result = 31 * result + (reportCreatorAccount?.hashCode() ?: 0)
        result = 31 * result + (reportFrequency?.hashCode() ?: 0)
        result = 31 * result + (reportGeneratorName?.hashCode() ?: 0)
        result = 31 * result + (reportType?.hashCode() ?: 0)
        result = 31 * result + (s3Location?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportGenerator

        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (lastReportGenerationTime != other.lastReportGenerationTime) return false
        if (lastRunFailureReason != other.lastRunFailureReason) return false
        if (lastRunStatus != other.lastRunStatus) return false
        if (licenseManagerReportGeneratorArn != other.licenseManagerReportGeneratorArn) return false
        if (reportContext != other.reportContext) return false
        if (reportCreatorAccount != other.reportCreatorAccount) return false
        if (reportFrequency != other.reportFrequency) return false
        if (reportGeneratorName != other.reportGeneratorName) return false
        if (reportType != other.reportType) return false
        if (s3Location != other.s3Location) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.licensemanager.model.ReportGenerator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Time the report was created.
         */
        public var createTime: kotlin.String? = null
        /**
         * Description of the report generator.
         */
        public var description: kotlin.String? = null
        /**
         * Time the last report was generated at.
         */
        public var lastReportGenerationTime: kotlin.String? = null
        /**
         * Failure message for the last report generation attempt.
         */
        public var lastRunFailureReason: kotlin.String? = null
        /**
         * Status of the last report generation attempt.
         */
        public var lastRunStatus: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of the report generator.
         */
        public var licenseManagerReportGeneratorArn: kotlin.String? = null
        /**
         * License configuration type for this generator.
         */
        public var reportContext: aws.sdk.kotlin.services.licensemanager.model.ReportContext? = null
        /**
         * The Amazon Web Services account ID used to create the report generator.
         */
        public var reportCreatorAccount: kotlin.String? = null
        /**
         * Details about how frequently reports are generated.
         */
        public var reportFrequency: aws.sdk.kotlin.services.licensemanager.model.ReportFrequency? = null
        /**
         * Name of the report generator.
         */
        public var reportGeneratorName: kotlin.String? = null
        /**
         * Type of reports that are generated.
         */
        public var reportType: List<ReportType>? = null
        /**
         * Details of the S3 bucket that report generator reports are published to.
         */
        public var s3Location: aws.sdk.kotlin.services.licensemanager.model.S3Location? = null
        /**
         * Tags associated with the report generator.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.licensemanager.model.ReportGenerator) : this() {
            this.createTime = x.createTime
            this.description = x.description
            this.lastReportGenerationTime = x.lastReportGenerationTime
            this.lastRunFailureReason = x.lastRunFailureReason
            this.lastRunStatus = x.lastRunStatus
            this.licenseManagerReportGeneratorArn = x.licenseManagerReportGeneratorArn
            this.reportContext = x.reportContext
            this.reportCreatorAccount = x.reportCreatorAccount
            this.reportFrequency = x.reportFrequency
            this.reportGeneratorName = x.reportGeneratorName
            this.reportType = x.reportType
            this.s3Location = x.s3Location
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.licensemanager.model.ReportGenerator = ReportGenerator(this)

        /**
         * construct an [aws.sdk.kotlin.services.licensemanager.model.ReportContext] inside the given [block]
         */
        public fun reportContext(block: aws.sdk.kotlin.services.licensemanager.model.ReportContext.Builder.() -> kotlin.Unit) {
            this.reportContext = aws.sdk.kotlin.services.licensemanager.model.ReportContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.licensemanager.model.ReportFrequency] inside the given [block]
         */
        public fun reportFrequency(block: aws.sdk.kotlin.services.licensemanager.model.ReportFrequency.Builder.() -> kotlin.Unit) {
            this.reportFrequency = aws.sdk.kotlin.services.licensemanager.model.ReportFrequency.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.licensemanager.model.S3Location] inside the given [block]
         */
        public fun s3Location(block: aws.sdk.kotlin.services.licensemanager.model.S3Location.Builder.() -> kotlin.Unit) {
            this.s3Location = aws.sdk.kotlin.services.licensemanager.model.S3Location.invoke(block)
        }
    }
}
