// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.model



/**
 * Describes product information for a license configuration.
 */
public class ProductInformation private constructor(builder: Builder) {
    /**
     * A Product information filter consists of a `ProductInformationFilterComparator` which is a logical operator, a `ProductInformationFilterName` which specifies the type of filter being declared, and a `ProductInformationFilterValue` that specifies the value to filter on.
     *
     * Accepted values for `ProductInformationFilterName` are listed here along with descriptions and valid options for `ProductInformationFilterComparator`.
     *
     * The following filters and are supported when the resource type is `SSM_MANAGED`:
     * + `Application Name` - The name of the application. Logical operator is `EQUALS`.
     * + `Application Publisher` - The publisher of the application. Logical operator is `EQUALS`.
     * + `Application Version` - The version of the application. Logical operator is `EQUALS`.
     * + `Platform Name` - The name of the platform. Logical operator is `EQUALS`.
     * + `Platform Type` - The platform type. Logical operator is `EQUALS`.
     * + `Tag:key` - The key of a tag attached to an Amazon Web Services resource you wish to exclude from automated discovery. Logical operator is `NOT_EQUALS`. The key for your tag must be appended to `Tag:` following the example: `Tag:name-of-your-key`. `ProductInformationFilterValue` is optional if you are not using values for the key.
     * + `AccountId` - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated discovery. Logical operator is `NOT_EQUALS`.
     * + `License Included` - The type of license included. Logical operators are `EQUALS` and `NOT_EQUALS`. Possible values are: `sql-server-enterprise` | `sql-server-standard` | `sql-server-web` | `windows-server-datacenter`.
     *
     * The following filters and logical operators are supported when the resource type is `RDS`:
     * + `Engine Edition` - The edition of the database engine. Logical operator is `EQUALS`. Possible values are: `oracle-ee` | `oracle-se` | `oracle-se1` | `oracle-se2`.
     * + `License Pack` - The license pack. Logical operator is `EQUALS`. Possible values are: `data guard` | `diagnostic pack sqlt` | `tuning pack sqlt` | `ols` | `olap`.
     */
    public val productInformationFilterList: List<ProductInformationFilter>? = builder.productInformationFilterList
    /**
     * Resource type. The possible values are `SSM_MANAGED` | `RDS`.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.licensemanager.model.ProductInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProductInformation(")
        append("productInformationFilterList=$productInformationFilterList,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = productInformationFilterList?.hashCode() ?: 0
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProductInformation

        if (productInformationFilterList != other.productInformationFilterList) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.licensemanager.model.ProductInformation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A Product information filter consists of a `ProductInformationFilterComparator` which is a logical operator, a `ProductInformationFilterName` which specifies the type of filter being declared, and a `ProductInformationFilterValue` that specifies the value to filter on.
         *
         * Accepted values for `ProductInformationFilterName` are listed here along with descriptions and valid options for `ProductInformationFilterComparator`.
         *
         * The following filters and are supported when the resource type is `SSM_MANAGED`:
         * + `Application Name` - The name of the application. Logical operator is `EQUALS`.
         * + `Application Publisher` - The publisher of the application. Logical operator is `EQUALS`.
         * + `Application Version` - The version of the application. Logical operator is `EQUALS`.
         * + `Platform Name` - The name of the platform. Logical operator is `EQUALS`.
         * + `Platform Type` - The platform type. Logical operator is `EQUALS`.
         * + `Tag:key` - The key of a tag attached to an Amazon Web Services resource you wish to exclude from automated discovery. Logical operator is `NOT_EQUALS`. The key for your tag must be appended to `Tag:` following the example: `Tag:name-of-your-key`. `ProductInformationFilterValue` is optional if you are not using values for the key.
         * + `AccountId` - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated discovery. Logical operator is `NOT_EQUALS`.
         * + `License Included` - The type of license included. Logical operators are `EQUALS` and `NOT_EQUALS`. Possible values are: `sql-server-enterprise` | `sql-server-standard` | `sql-server-web` | `windows-server-datacenter`.
         *
         * The following filters and logical operators are supported when the resource type is `RDS`:
         * + `Engine Edition` - The edition of the database engine. Logical operator is `EQUALS`. Possible values are: `oracle-ee` | `oracle-se` | `oracle-se1` | `oracle-se2`.
         * + `License Pack` - The license pack. Logical operator is `EQUALS`. Possible values are: `data guard` | `diagnostic pack sqlt` | `tuning pack sqlt` | `ols` | `olap`.
         */
        public var productInformationFilterList: List<ProductInformationFilter>? = null
        /**
         * Resource type. The possible values are `SSM_MANAGED` | `RDS`.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.licensemanager.model.ProductInformation) : this() {
            this.productInformationFilterList = x.productInformationFilterList
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.licensemanager.model.ProductInformation = ProductInformation(this)
    }
}
