// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager.model



public class CreateLicenseConfigurationRequest private constructor(builder: Builder) {
    /**
     * Description of the license configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * When true, disassociates a resource when software is uninstalled.
     */
    public val disassociateWhenNotFound: kotlin.Boolean? = builder.disassociateWhenNotFound
    /**
     * Number of licenses managed by the license configuration.
     */
    public val licenseCount: kotlin.Long? = builder.licenseCount
    /**
     * Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.
     */
    public val licenseCountHardLimit: kotlin.Boolean? = builder.licenseCountHardLimit
    /**
     * Dimension used to track the license inventory.
     */
    public val licenseCountingType: aws.sdk.kotlin.services.licensemanager.model.LicenseCountingType? = builder.licenseCountingType
    /**
     * License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.
     * + `Cores` dimension: `allowedTenancy` | `licenseAffinityToHost` | `maximumCores` | `minimumCores`
     * + `Instances` dimension: `allowedTenancy` | `maximumCores` | `minimumCores` | `maximumSockets` | `minimumSockets` | `maximumVcpus` | `minimumVcpus`
     * + `Sockets` dimension: `allowedTenancy` | `licenseAffinityToHost` | `maximumSockets` | `minimumSockets`
     * + `vCPUs` dimension: `allowedTenancy` | `honorVcpuOptimization` | `maximumVcpus` | `minimumVcpus`
     *
     * The unit for `licenseAffinityToHost` is days and the range is 1 to 180. The possible values for `allowedTenancy` are `EC2-Default`, `EC2-DedicatedHost`, and `EC2-DedicatedInstance`. The possible values for `honorVcpuOptimization` are `True` and `False`.
     */
    public val licenseRules: List<String>? = builder.licenseRules
    /**
     * Name of the license configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Product information.
     */
    public val productInformationList: List<ProductInformation>? = builder.productInformationList
    /**
     * Tags to add to the license configuration.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLicenseConfigurationRequest(")
        append("description=$description,")
        append("disassociateWhenNotFound=$disassociateWhenNotFound,")
        append("licenseCount=$licenseCount,")
        append("licenseCountHardLimit=$licenseCountHardLimit,")
        append("licenseCountingType=$licenseCountingType,")
        append("licenseRules=$licenseRules,")
        append("name=$name,")
        append("productInformationList=$productInformationList,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (disassociateWhenNotFound?.hashCode() ?: 0)
        result = 31 * result + (licenseCount?.hashCode() ?: 0)
        result = 31 * result + (licenseCountHardLimit?.hashCode() ?: 0)
        result = 31 * result + (licenseCountingType?.hashCode() ?: 0)
        result = 31 * result + (licenseRules?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (productInformationList?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLicenseConfigurationRequest

        if (description != other.description) return false
        if (disassociateWhenNotFound != other.disassociateWhenNotFound) return false
        if (licenseCount != other.licenseCount) return false
        if (licenseCountHardLimit != other.licenseCountHardLimit) return false
        if (licenseCountingType != other.licenseCountingType) return false
        if (licenseRules != other.licenseRules) return false
        if (name != other.name) return false
        if (productInformationList != other.productInformationList) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Description of the license configuration.
         */
        public var description: kotlin.String? = null
        /**
         * When true, disassociates a resource when software is uninstalled.
         */
        public var disassociateWhenNotFound: kotlin.Boolean? = null
        /**
         * Number of licenses managed by the license configuration.
         */
        public var licenseCount: kotlin.Long? = null
        /**
         * Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.
         */
        public var licenseCountHardLimit: kotlin.Boolean? = null
        /**
         * Dimension used to track the license inventory.
         */
        public var licenseCountingType: aws.sdk.kotlin.services.licensemanager.model.LicenseCountingType? = null
        /**
         * License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.
         * + `Cores` dimension: `allowedTenancy` | `licenseAffinityToHost` | `maximumCores` | `minimumCores`
         * + `Instances` dimension: `allowedTenancy` | `maximumCores` | `minimumCores` | `maximumSockets` | `minimumSockets` | `maximumVcpus` | `minimumVcpus`
         * + `Sockets` dimension: `allowedTenancy` | `licenseAffinityToHost` | `maximumSockets` | `minimumSockets`
         * + `vCPUs` dimension: `allowedTenancy` | `honorVcpuOptimization` | `maximumVcpus` | `minimumVcpus`
         *
         * The unit for `licenseAffinityToHost` is days and the range is 1 to 180. The possible values for `allowedTenancy` are `EC2-Default`, `EC2-DedicatedHost`, and `EC2-DedicatedInstance`. The possible values for `honorVcpuOptimization` are `True` and `False`.
         */
        public var licenseRules: List<String>? = null
        /**
         * Name of the license configuration.
         */
        public var name: kotlin.String? = null
        /**
         * Product information.
         */
        public var productInformationList: List<ProductInformation>? = null
        /**
         * Tags to add to the license configuration.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConfigurationRequest) : this() {
            this.description = x.description
            this.disassociateWhenNotFound = x.disassociateWhenNotFound
            this.licenseCount = x.licenseCount
            this.licenseCountHardLimit = x.licenseCountHardLimit
            this.licenseCountingType = x.licenseCountingType
            this.licenseRules = x.licenseRules
            this.name = x.name
            this.productInformationList = x.productInformationList
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConfigurationRequest = CreateLicenseConfigurationRequest(this)
    }
}
