// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.licensemanager.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.licensemanager.model.*
import aws.sdk.kotlin.services.licensemanager.model.AcceptGrantRequest
import aws.sdk.kotlin.services.licensemanager.model.AcceptGrantResponse
import aws.sdk.kotlin.services.licensemanager.model.CheckInLicenseRequest
import aws.sdk.kotlin.services.licensemanager.model.CheckInLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.CheckoutBorrowLicenseRequest
import aws.sdk.kotlin.services.licensemanager.model.CheckoutBorrowLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.CheckoutLicenseRequest
import aws.sdk.kotlin.services.licensemanager.model.CheckoutLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateGrantRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateGrantResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateGrantVersionRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateGrantVersionResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConfigurationRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConfigurationResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConversionTaskForResourceRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseConversionTaskForResourceResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseManagerReportGeneratorRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseVersionRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateLicenseVersionResponse
import aws.sdk.kotlin.services.licensemanager.model.CreateTokenRequest
import aws.sdk.kotlin.services.licensemanager.model.CreateTokenResponse
import aws.sdk.kotlin.services.licensemanager.model.DeleteGrantRequest
import aws.sdk.kotlin.services.licensemanager.model.DeleteGrantResponse
import aws.sdk.kotlin.services.licensemanager.model.DeleteLicenseConfigurationRequest
import aws.sdk.kotlin.services.licensemanager.model.DeleteLicenseConfigurationResponse
import aws.sdk.kotlin.services.licensemanager.model.DeleteLicenseManagerReportGeneratorRequest
import aws.sdk.kotlin.services.licensemanager.model.DeleteLicenseManagerReportGeneratorResponse
import aws.sdk.kotlin.services.licensemanager.model.DeleteLicenseRequest
import aws.sdk.kotlin.services.licensemanager.model.DeleteLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.DeleteTokenRequest
import aws.sdk.kotlin.services.licensemanager.model.DeleteTokenResponse
import aws.sdk.kotlin.services.licensemanager.model.ExtendLicenseConsumptionRequest
import aws.sdk.kotlin.services.licensemanager.model.ExtendLicenseConsumptionResponse
import aws.sdk.kotlin.services.licensemanager.model.GetAccessTokenRequest
import aws.sdk.kotlin.services.licensemanager.model.GetAccessTokenResponse
import aws.sdk.kotlin.services.licensemanager.model.GetGrantRequest
import aws.sdk.kotlin.services.licensemanager.model.GetGrantResponse
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseConfigurationRequest
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseConfigurationResponse
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseConversionTaskRequest
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseConversionTaskResponse
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseManagerReportGeneratorResponse
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseRequest
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseResponse
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseUsageRequest
import aws.sdk.kotlin.services.licensemanager.model.GetLicenseUsageResponse
import aws.sdk.kotlin.services.licensemanager.model.GetServiceSettingsRequest
import aws.sdk.kotlin.services.licensemanager.model.GetServiceSettingsResponse
import aws.sdk.kotlin.services.licensemanager.model.ListAssociationsForLicenseConfigurationRequest
import aws.sdk.kotlin.services.licensemanager.model.ListAssociationsForLicenseConfigurationResponse
import aws.sdk.kotlin.services.licensemanager.model.ListDistributedGrantsRequest
import aws.sdk.kotlin.services.licensemanager.model.ListDistributedGrantsResponse
import aws.sdk.kotlin.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsRequest
import aws.sdk.kotlin.services.licensemanager.model.ListFailuresForLicenseConfigurationOperationsResponse
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseConfigurationsRequest
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseConfigurationsResponse
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseConversionTasksRequest
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseConversionTasksResponse
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseManagerReportGeneratorsRequest
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseManagerReportGeneratorsResponse
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseSpecificationsForResourceRequest
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseSpecificationsForResourceResponse
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseVersionsRequest
import aws.sdk.kotlin.services.licensemanager.model.ListLicenseVersionsResponse
import aws.sdk.kotlin.services.licensemanager.model.ListLicensesRequest
import aws.sdk.kotlin.services.licensemanager.model.ListLicensesResponse
import aws.sdk.kotlin.services.licensemanager.model.ListReceivedGrantsRequest
import aws.sdk.kotlin.services.licensemanager.model.ListReceivedGrantsResponse
import aws.sdk.kotlin.services.licensemanager.model.ListReceivedLicensesRequest
import aws.sdk.kotlin.services.licensemanager.model.ListReceivedLicensesResponse
import aws.sdk.kotlin.services.licensemanager.model.ListResourceInventoryRequest
import aws.sdk.kotlin.services.licensemanager.model.ListResourceInventoryResponse
import aws.sdk.kotlin.services.licensemanager.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.licensemanager.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.licensemanager.model.ListTokensRequest
import aws.sdk.kotlin.services.licensemanager.model.ListTokensResponse
import aws.sdk.kotlin.services.licensemanager.model.ListUsageForLicenseConfigurationRequest
import aws.sdk.kotlin.services.licensemanager.model.ListUsageForLicenseConfigurationResponse
import aws.sdk.kotlin.services.licensemanager.model.RejectGrantRequest
import aws.sdk.kotlin.services.licensemanager.model.RejectGrantResponse
import aws.sdk.kotlin.services.licensemanager.model.TagResourceRequest
import aws.sdk.kotlin.services.licensemanager.model.TagResourceResponse
import aws.sdk.kotlin.services.licensemanager.model.UntagResourceRequest
import aws.sdk.kotlin.services.licensemanager.model.UntagResourceResponse
import aws.sdk.kotlin.services.licensemanager.model.UpdateLicenseConfigurationRequest
import aws.sdk.kotlin.services.licensemanager.model.UpdateLicenseConfigurationResponse
import aws.sdk.kotlin.services.licensemanager.model.UpdateLicenseManagerReportGeneratorRequest
import aws.sdk.kotlin.services.licensemanager.model.UpdateLicenseManagerReportGeneratorResponse
import aws.sdk.kotlin.services.licensemanager.model.UpdateLicenseSpecificationsForResourceRequest
import aws.sdk.kotlin.services.licensemanager.model.UpdateLicenseSpecificationsForResourceResponse
import aws.sdk.kotlin.services.licensemanager.model.UpdateServiceSettingsRequest
import aws.sdk.kotlin.services.licensemanager.model.UpdateServiceSettingsResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * License Manager makes it easier to manage licenses from software vendors across multiple Amazon Web Services accounts and on-premises servers.
 */
public interface LicenseManagerClient : SdkClient {

    override val serviceName: String
        get() = "License Manager"
    /**
     * LicenseManagerClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): LicenseManagerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultLicenseManagerClient(config)
        }

        public operator fun invoke(config: Config): LicenseManagerClient = DefaultLicenseManagerClient(config)

        /**
         * Construct a [LicenseManagerClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): LicenseManagerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultLicenseManagerClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts the specified grant.
     */
    public suspend fun acceptGrant(input: AcceptGrantRequest): AcceptGrantResponse

    /**
     * Checks in the specified license. Check in a license when it is no longer in use.
     */
    public suspend fun checkInLicense(input: CheckInLicenseRequest): CheckInLicenseResponse

    /**
     * Checks out the specified license for offline use.
     */
    public suspend fun checkoutBorrowLicense(input: CheckoutBorrowLicenseRequest): CheckoutBorrowLicenseResponse

    /**
     * Checks out the specified license.
     */
    public suspend fun checkoutLicense(input: CheckoutLicenseRequest): CheckoutLicenseResponse

    /**
     * Creates a grant for the specified license. A grant shares the use of license entitlements with specific Amazon Web Services accounts.
     */
    public suspend fun createGrant(input: CreateGrantRequest): CreateGrantResponse

    /**
     * Creates a new version of the specified grant.
     */
    public suspend fun createGrantVersion(input: CreateGrantVersionRequest): CreateGrantVersionResponse

    /**
     * Creates a license.
     */
    public suspend fun createLicense(input: CreateLicenseRequest): CreateLicenseResponse

    /**
     * Creates a license configuration.
     *
     * A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to host (how long a license must be associated with a host), and the number of licenses purchased and used.
     */
    public suspend fun createLicenseConfiguration(input: CreateLicenseConfigurationRequest): CreateLicenseConfigurationResponse

    /**
     * Creates a new license conversion task.
     */
    public suspend fun createLicenseConversionTaskForResource(input: CreateLicenseConversionTaskForResourceRequest): CreateLicenseConversionTaskForResourceResponse

    /**
     * Creates a report generator.
     */
    public suspend fun createLicenseManagerReportGenerator(input: CreateLicenseManagerReportGeneratorRequest): CreateLicenseManagerReportGeneratorResponse

    /**
     * Creates a new version of the specified license.
     */
    public suspend fun createLicenseVersion(input: CreateLicenseVersionRequest): CreateLicenseVersionResponse

    /**
     * Creates a long-lived token.
     *
     * A refresh token is a JWT token used to get an access token. With an access token, you can call AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the specified license.
     */
    public suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse

    /**
     * Deletes the specified grant.
     */
    public suspend fun deleteGrant(input: DeleteGrantRequest): DeleteGrantResponse

    /**
     * Deletes the specified license.
     */
    public suspend fun deleteLicense(input: DeleteLicenseRequest): DeleteLicenseResponse

    /**
     * Deletes the specified license configuration.
     *
     * You cannot delete a license configuration that is in use.
     */
    public suspend fun deleteLicenseConfiguration(input: DeleteLicenseConfigurationRequest): DeleteLicenseConfigurationResponse

    /**
     * Deletes the specified report generator.
     *
     * This action deletes the report generator, which stops it from generating future reports. The action cannot be reversed. It has no effect on the previous reports from this generator.
     */
    public suspend fun deleteLicenseManagerReportGenerator(input: DeleteLicenseManagerReportGeneratorRequest): DeleteLicenseManagerReportGeneratorResponse

    /**
     * Deletes the specified token. Must be called in the license home Region.
     */
    public suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse

    /**
     * Extends the expiration date for license consumption.
     */
    public suspend fun extendLicenseConsumption(input: ExtendLicenseConsumptionRequest): ExtendLicenseConsumptionResponse

    /**
     * Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
     */
    public suspend fun getAccessToken(input: GetAccessTokenRequest): GetAccessTokenResponse

    /**
     * Gets detailed information about the specified grant.
     */
    public suspend fun getGrant(input: GetGrantRequest): GetGrantResponse

    /**
     * Gets detailed information about the specified license.
     */
    public suspend fun getLicense(input: GetLicenseRequest): GetLicenseResponse

    /**
     * Gets detailed information about the specified license configuration.
     */
    public suspend fun getLicenseConfiguration(input: GetLicenseConfigurationRequest): GetLicenseConfigurationResponse

    /**
     * Gets information about the specified license type conversion task.
     */
    public suspend fun getLicenseConversionTask(input: GetLicenseConversionTaskRequest): GetLicenseConversionTaskResponse

    /**
     * Gets information about the specified report generator.
     */
    public suspend fun getLicenseManagerReportGenerator(input: GetLicenseManagerReportGeneratorRequest): GetLicenseManagerReportGeneratorResponse

    /**
     * Gets detailed information about the usage of the specified license.
     */
    public suspend fun getLicenseUsage(input: GetLicenseUsageRequest): GetLicenseUsageResponse

    /**
     * Gets the License Manager settings for the current Region.
     */
    public suspend fun getServiceSettings(input: GetServiceSettingsRequest = GetServiceSettingsRequest {}): GetServiceSettingsResponse

    /**
     * Lists the resource associations for the specified license configuration.
     *
     * Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped instance might not consume a license (depending on the license rules).
     */
    public suspend fun listAssociationsForLicenseConfiguration(input: ListAssociationsForLicenseConfigurationRequest): ListAssociationsForLicenseConfigurationResponse

    /**
     * Lists the grants distributed for the specified license.
     */
    public suspend fun listDistributedGrants(input: ListDistributedGrantsRequest = ListDistributedGrantsRequest {}): ListDistributedGrantsResponse

    /**
     * Lists the license configuration operations that failed.
     */
    public suspend fun listFailuresForLicenseConfigurationOperations(input: ListFailuresForLicenseConfigurationOperationsRequest): ListFailuresForLicenseConfigurationOperationsResponse

    /**
     * Lists the license configurations for your account.
     */
    public suspend fun listLicenseConfigurations(input: ListLicenseConfigurationsRequest = ListLicenseConfigurationsRequest {}): ListLicenseConfigurationsResponse

    /**
     * Lists the license type conversion tasks for your account.
     */
    public suspend fun listLicenseConversionTasks(input: ListLicenseConversionTasksRequest = ListLicenseConversionTasksRequest {}): ListLicenseConversionTasksResponse

    /**
     * Lists the report generators for your account.
     */
    public suspend fun listLicenseManagerReportGenerators(input: ListLicenseManagerReportGeneratorsRequest = ListLicenseManagerReportGeneratorsRequest {}): ListLicenseManagerReportGeneratorsResponse

    /**
     * Describes the license configurations for the specified resource.
     */
    public suspend fun listLicenseSpecificationsForResource(input: ListLicenseSpecificationsForResourceRequest): ListLicenseSpecificationsForResourceResponse

    /**
     * Lists all versions of the specified license.
     */
    public suspend fun listLicenseVersions(input: ListLicenseVersionsRequest): ListLicenseVersionsResponse

    /**
     * Lists the licenses for your account.
     */
    public suspend fun listLicenses(input: ListLicensesRequest = ListLicensesRequest {}): ListLicensesResponse

    /**
     * Lists grants that are received but not accepted.
     */
    public suspend fun listReceivedGrants(input: ListReceivedGrantsRequest = ListReceivedGrantsRequest {}): ListReceivedGrantsResponse

    /**
     * Lists received licenses.
     */
    public suspend fun listReceivedLicenses(input: ListReceivedLicensesRequest = ListReceivedLicensesRequest {}): ListReceivedLicensesResponse

    /**
     * Lists resources managed using Systems Manager inventory.
     */
    public suspend fun listResourceInventory(input: ListResourceInventoryRequest = ListResourceInventoryRequest {}): ListResourceInventoryResponse

    /**
     * Lists the tags for the specified license configuration.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists your tokens.
     */
    public suspend fun listTokens(input: ListTokensRequest = ListTokensRequest {}): ListTokensResponse

    /**
     * Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time. Use this action to audit the current license consumption for any license inventory and configuration.
     */
    public suspend fun listUsageForLicenseConfiguration(input: ListUsageForLicenseConfigurationRequest): ListUsageForLicenseConfigurationResponse

    /**
     * Rejects the specified grant.
     */
    public suspend fun rejectGrant(input: RejectGrantRequest): RejectGrantResponse

    /**
     * Adds the specified tags to the specified license configuration.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified license configuration.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Modifies the attributes of an existing license configuration.
     */
    public suspend fun updateLicenseConfiguration(input: UpdateLicenseConfigurationRequest): UpdateLicenseConfigurationResponse

    /**
     * Updates a report generator.
     *
     * After you make changes to a report generator, it starts generating new reports within 60 minutes of being updated.
     */
    public suspend fun updateLicenseManagerReportGenerator(input: UpdateLicenseManagerReportGeneratorRequest): UpdateLicenseManagerReportGeneratorResponse

    /**
     * Adds or removes the specified license configurations for the specified Amazon Web Services resource.
     *
     * You can update the license specifications of AMIs, instances, and hosts. You cannot update the license specifications for launch templates and CloudFormation templates, as they send license configurations to the operation that creates the resource.
     */
    public suspend fun updateLicenseSpecificationsForResource(input: UpdateLicenseSpecificationsForResourceRequest): UpdateLicenseSpecificationsForResourceResponse

    /**
     * Updates License Manager settings for the current Region.
     */
    public suspend fun updateServiceSettings(input: UpdateServiceSettingsRequest = UpdateServiceSettingsRequest {}): UpdateServiceSettingsResponse
}

/**
 * Accepts the specified grant.
 */
public suspend inline fun LicenseManagerClient.acceptGrant(crossinline block: AcceptGrantRequest.Builder.() -> Unit): AcceptGrantResponse = acceptGrant(AcceptGrantRequest.Builder().apply(block).build())

/**
 * Checks in the specified license. Check in a license when it is no longer in use.
 */
public suspend inline fun LicenseManagerClient.checkInLicense(crossinline block: CheckInLicenseRequest.Builder.() -> Unit): CheckInLicenseResponse = checkInLicense(CheckInLicenseRequest.Builder().apply(block).build())

/**
 * Checks out the specified license for offline use.
 */
public suspend inline fun LicenseManagerClient.checkoutBorrowLicense(crossinline block: CheckoutBorrowLicenseRequest.Builder.() -> Unit): CheckoutBorrowLicenseResponse = checkoutBorrowLicense(CheckoutBorrowLicenseRequest.Builder().apply(block).build())

/**
 * Checks out the specified license.
 */
public suspend inline fun LicenseManagerClient.checkoutLicense(crossinline block: CheckoutLicenseRequest.Builder.() -> Unit): CheckoutLicenseResponse = checkoutLicense(CheckoutLicenseRequest.Builder().apply(block).build())

/**
 * Creates a grant for the specified license. A grant shares the use of license entitlements with specific Amazon Web Services accounts.
 */
public suspend inline fun LicenseManagerClient.createGrant(crossinline block: CreateGrantRequest.Builder.() -> Unit): CreateGrantResponse = createGrant(CreateGrantRequest.Builder().apply(block).build())

/**
 * Creates a new version of the specified grant.
 */
public suspend inline fun LicenseManagerClient.createGrantVersion(crossinline block: CreateGrantVersionRequest.Builder.() -> Unit): CreateGrantVersionResponse = createGrantVersion(CreateGrantVersionRequest.Builder().apply(block).build())

/**
 * Creates a license.
 */
public suspend inline fun LicenseManagerClient.createLicense(crossinline block: CreateLicenseRequest.Builder.() -> Unit): CreateLicenseResponse = createLicense(CreateLicenseRequest.Builder().apply(block).build())

/**
 * Creates a license configuration.
 *
 * A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to host (how long a license must be associated with a host), and the number of licenses purchased and used.
 */
public suspend inline fun LicenseManagerClient.createLicenseConfiguration(crossinline block: CreateLicenseConfigurationRequest.Builder.() -> Unit): CreateLicenseConfigurationResponse = createLicenseConfiguration(CreateLicenseConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a new license conversion task.
 */
public suspend inline fun LicenseManagerClient.createLicenseConversionTaskForResource(crossinline block: CreateLicenseConversionTaskForResourceRequest.Builder.() -> Unit): CreateLicenseConversionTaskForResourceResponse = createLicenseConversionTaskForResource(CreateLicenseConversionTaskForResourceRequest.Builder().apply(block).build())

/**
 * Creates a report generator.
 */
public suspend inline fun LicenseManagerClient.createLicenseManagerReportGenerator(crossinline block: CreateLicenseManagerReportGeneratorRequest.Builder.() -> Unit): CreateLicenseManagerReportGeneratorResponse = createLicenseManagerReportGenerator(CreateLicenseManagerReportGeneratorRequest.Builder().apply(block).build())

/**
 * Creates a new version of the specified license.
 */
public suspend inline fun LicenseManagerClient.createLicenseVersion(crossinline block: CreateLicenseVersionRequest.Builder.() -> Unit): CreateLicenseVersionResponse = createLicenseVersion(CreateLicenseVersionRequest.Builder().apply(block).build())

/**
 * Creates a long-lived token.
 *
 * A refresh token is a JWT token used to get an access token. With an access token, you can call AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the specified license.
 */
public suspend inline fun LicenseManagerClient.createToken(crossinline block: CreateTokenRequest.Builder.() -> Unit): CreateTokenResponse = createToken(CreateTokenRequest.Builder().apply(block).build())

/**
 * Deletes the specified grant.
 */
public suspend inline fun LicenseManagerClient.deleteGrant(crossinline block: DeleteGrantRequest.Builder.() -> Unit): DeleteGrantResponse = deleteGrant(DeleteGrantRequest.Builder().apply(block).build())

/**
 * Deletes the specified license.
 */
public suspend inline fun LicenseManagerClient.deleteLicense(crossinline block: DeleteLicenseRequest.Builder.() -> Unit): DeleteLicenseResponse = deleteLicense(DeleteLicenseRequest.Builder().apply(block).build())

/**
 * Deletes the specified license configuration.
 *
 * You cannot delete a license configuration that is in use.
 */
public suspend inline fun LicenseManagerClient.deleteLicenseConfiguration(crossinline block: DeleteLicenseConfigurationRequest.Builder.() -> Unit): DeleteLicenseConfigurationResponse = deleteLicenseConfiguration(DeleteLicenseConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified report generator.
 *
 * This action deletes the report generator, which stops it from generating future reports. The action cannot be reversed. It has no effect on the previous reports from this generator.
 */
public suspend inline fun LicenseManagerClient.deleteLicenseManagerReportGenerator(crossinline block: DeleteLicenseManagerReportGeneratorRequest.Builder.() -> Unit): DeleteLicenseManagerReportGeneratorResponse = deleteLicenseManagerReportGenerator(DeleteLicenseManagerReportGeneratorRequest.Builder().apply(block).build())

/**
 * Deletes the specified token. Must be called in the license home Region.
 */
public suspend inline fun LicenseManagerClient.deleteToken(crossinline block: DeleteTokenRequest.Builder.() -> Unit): DeleteTokenResponse = deleteToken(DeleteTokenRequest.Builder().apply(block).build())

/**
 * Extends the expiration date for license consumption.
 */
public suspend inline fun LicenseManagerClient.extendLicenseConsumption(crossinline block: ExtendLicenseConsumptionRequest.Builder.() -> Unit): ExtendLicenseConsumptionResponse = extendLicenseConsumption(ExtendLicenseConsumptionRequest.Builder().apply(block).build())

/**
 * Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
 */
public suspend inline fun LicenseManagerClient.getAccessToken(crossinline block: GetAccessTokenRequest.Builder.() -> Unit): GetAccessTokenResponse = getAccessToken(GetAccessTokenRequest.Builder().apply(block).build())

/**
 * Gets detailed information about the specified grant.
 */
public suspend inline fun LicenseManagerClient.getGrant(crossinline block: GetGrantRequest.Builder.() -> Unit): GetGrantResponse = getGrant(GetGrantRequest.Builder().apply(block).build())

/**
 * Gets detailed information about the specified license.
 */
public suspend inline fun LicenseManagerClient.getLicense(crossinline block: GetLicenseRequest.Builder.() -> Unit): GetLicenseResponse = getLicense(GetLicenseRequest.Builder().apply(block).build())

/**
 * Gets detailed information about the specified license configuration.
 */
public suspend inline fun LicenseManagerClient.getLicenseConfiguration(crossinline block: GetLicenseConfigurationRequest.Builder.() -> Unit): GetLicenseConfigurationResponse = getLicenseConfiguration(GetLicenseConfigurationRequest.Builder().apply(block).build())

/**
 * Gets information about the specified license type conversion task.
 */
public suspend inline fun LicenseManagerClient.getLicenseConversionTask(crossinline block: GetLicenseConversionTaskRequest.Builder.() -> Unit): GetLicenseConversionTaskResponse = getLicenseConversionTask(GetLicenseConversionTaskRequest.Builder().apply(block).build())

/**
 * Gets information about the specified report generator.
 */
public suspend inline fun LicenseManagerClient.getLicenseManagerReportGenerator(crossinline block: GetLicenseManagerReportGeneratorRequest.Builder.() -> Unit): GetLicenseManagerReportGeneratorResponse = getLicenseManagerReportGenerator(GetLicenseManagerReportGeneratorRequest.Builder().apply(block).build())

/**
 * Gets detailed information about the usage of the specified license.
 */
public suspend inline fun LicenseManagerClient.getLicenseUsage(crossinline block: GetLicenseUsageRequest.Builder.() -> Unit): GetLicenseUsageResponse = getLicenseUsage(GetLicenseUsageRequest.Builder().apply(block).build())

/**
 * Gets the License Manager settings for the current Region.
 */
public suspend inline fun LicenseManagerClient.getServiceSettings(crossinline block: GetServiceSettingsRequest.Builder.() -> Unit): GetServiceSettingsResponse = getServiceSettings(GetServiceSettingsRequest.Builder().apply(block).build())

/**
 * Lists the resource associations for the specified license configuration.
 *
 * Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped instance might not consume a license (depending on the license rules).
 */
public suspend inline fun LicenseManagerClient.listAssociationsForLicenseConfiguration(crossinline block: ListAssociationsForLicenseConfigurationRequest.Builder.() -> Unit): ListAssociationsForLicenseConfigurationResponse = listAssociationsForLicenseConfiguration(ListAssociationsForLicenseConfigurationRequest.Builder().apply(block).build())

/**
 * Lists the grants distributed for the specified license.
 */
public suspend inline fun LicenseManagerClient.listDistributedGrants(crossinline block: ListDistributedGrantsRequest.Builder.() -> Unit): ListDistributedGrantsResponse = listDistributedGrants(ListDistributedGrantsRequest.Builder().apply(block).build())

/**
 * Lists the license configuration operations that failed.
 */
public suspend inline fun LicenseManagerClient.listFailuresForLicenseConfigurationOperations(crossinline block: ListFailuresForLicenseConfigurationOperationsRequest.Builder.() -> Unit): ListFailuresForLicenseConfigurationOperationsResponse = listFailuresForLicenseConfigurationOperations(ListFailuresForLicenseConfigurationOperationsRequest.Builder().apply(block).build())

/**
 * Lists the license configurations for your account.
 */
public suspend inline fun LicenseManagerClient.listLicenseConfigurations(crossinline block: ListLicenseConfigurationsRequest.Builder.() -> Unit): ListLicenseConfigurationsResponse = listLicenseConfigurations(ListLicenseConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the license type conversion tasks for your account.
 */
public suspend inline fun LicenseManagerClient.listLicenseConversionTasks(crossinline block: ListLicenseConversionTasksRequest.Builder.() -> Unit): ListLicenseConversionTasksResponse = listLicenseConversionTasks(ListLicenseConversionTasksRequest.Builder().apply(block).build())

/**
 * Lists the report generators for your account.
 */
public suspend inline fun LicenseManagerClient.listLicenseManagerReportGenerators(crossinline block: ListLicenseManagerReportGeneratorsRequest.Builder.() -> Unit): ListLicenseManagerReportGeneratorsResponse = listLicenseManagerReportGenerators(ListLicenseManagerReportGeneratorsRequest.Builder().apply(block).build())

/**
 * Describes the license configurations for the specified resource.
 */
public suspend inline fun LicenseManagerClient.listLicenseSpecificationsForResource(crossinline block: ListLicenseSpecificationsForResourceRequest.Builder.() -> Unit): ListLicenseSpecificationsForResourceResponse = listLicenseSpecificationsForResource(ListLicenseSpecificationsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all versions of the specified license.
 */
public suspend inline fun LicenseManagerClient.listLicenseVersions(crossinline block: ListLicenseVersionsRequest.Builder.() -> Unit): ListLicenseVersionsResponse = listLicenseVersions(ListLicenseVersionsRequest.Builder().apply(block).build())

/**
 * Lists the licenses for your account.
 */
public suspend inline fun LicenseManagerClient.listLicenses(crossinline block: ListLicensesRequest.Builder.() -> Unit): ListLicensesResponse = listLicenses(ListLicensesRequest.Builder().apply(block).build())

/**
 * Lists grants that are received but not accepted.
 */
public suspend inline fun LicenseManagerClient.listReceivedGrants(crossinline block: ListReceivedGrantsRequest.Builder.() -> Unit): ListReceivedGrantsResponse = listReceivedGrants(ListReceivedGrantsRequest.Builder().apply(block).build())

/**
 * Lists received licenses.
 */
public suspend inline fun LicenseManagerClient.listReceivedLicenses(crossinline block: ListReceivedLicensesRequest.Builder.() -> Unit): ListReceivedLicensesResponse = listReceivedLicenses(ListReceivedLicensesRequest.Builder().apply(block).build())

/**
 * Lists resources managed using Systems Manager inventory.
 */
public suspend inline fun LicenseManagerClient.listResourceInventory(crossinline block: ListResourceInventoryRequest.Builder.() -> Unit): ListResourceInventoryResponse = listResourceInventory(ListResourceInventoryRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified license configuration.
 */
public suspend inline fun LicenseManagerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists your tokens.
 */
public suspend inline fun LicenseManagerClient.listTokens(crossinline block: ListTokensRequest.Builder.() -> Unit): ListTokensResponse = listTokens(ListTokensRequest.Builder().apply(block).build())

/**
 * Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time. Use this action to audit the current license consumption for any license inventory and configuration.
 */
public suspend inline fun LicenseManagerClient.listUsageForLicenseConfiguration(crossinline block: ListUsageForLicenseConfigurationRequest.Builder.() -> Unit): ListUsageForLicenseConfigurationResponse = listUsageForLicenseConfiguration(ListUsageForLicenseConfigurationRequest.Builder().apply(block).build())

/**
 * Rejects the specified grant.
 */
public suspend inline fun LicenseManagerClient.rejectGrant(crossinline block: RejectGrantRequest.Builder.() -> Unit): RejectGrantResponse = rejectGrant(RejectGrantRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified license configuration.
 */
public suspend inline fun LicenseManagerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified license configuration.
 */
public suspend inline fun LicenseManagerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Modifies the attributes of an existing license configuration.
 */
public suspend inline fun LicenseManagerClient.updateLicenseConfiguration(crossinline block: UpdateLicenseConfigurationRequest.Builder.() -> Unit): UpdateLicenseConfigurationResponse = updateLicenseConfiguration(UpdateLicenseConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a report generator.
 *
 * After you make changes to a report generator, it starts generating new reports within 60 minutes of being updated.
 */
public suspend inline fun LicenseManagerClient.updateLicenseManagerReportGenerator(crossinline block: UpdateLicenseManagerReportGeneratorRequest.Builder.() -> Unit): UpdateLicenseManagerReportGeneratorResponse = updateLicenseManagerReportGenerator(UpdateLicenseManagerReportGeneratorRequest.Builder().apply(block).build())

/**
 * Adds or removes the specified license configurations for the specified Amazon Web Services resource.
 *
 * You can update the license specifications of AMIs, instances, and hosts. You cannot update the license specifications for launch templates and CloudFormation templates, as they send license configurations to the operation that creates the resource.
 */
public suspend inline fun LicenseManagerClient.updateLicenseSpecificationsForResource(crossinline block: UpdateLicenseSpecificationsForResourceRequest.Builder.() -> Unit): UpdateLicenseSpecificationsForResourceResponse = updateLicenseSpecificationsForResource(UpdateLicenseSpecificationsForResourceRequest.Builder().apply(block).build())

/**
 * Updates License Manager settings for the current Region.
 */
public suspend inline fun LicenseManagerClient.updateServiceSettings(crossinline block: UpdateServiceSettingsRequest.Builder.() -> Unit): UpdateServiceSettingsResponse = updateServiceSettings(UpdateServiceSettingsRequest.Builder().apply(block).build())
