// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.licensemanager

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.licensemanager.model.*
import aws.sdk.kotlin.services.licensemanager.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "License Manager"
public const val ServiceApiVersion: String = "2018-08-01"
public const val SdkVersion: String = "0.17.11-beta"

internal class DefaultLicenseManagerClient(override val config: LicenseManagerClient.Config) : LicenseManagerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts the specified grant.
     */
    override suspend fun acceptGrant(input: AcceptGrantRequest): AcceptGrantResponse {
        val op = SdkHttpOperation.build<AcceptGrantRequest, AcceptGrantResponse> {
            serializer = AcceptGrantOperationSerializer()
            deserializer = AcceptGrantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptGrant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Checks in the specified license. Check in a license when it is no longer in use.
     */
    override suspend fun checkInLicense(input: CheckInLicenseRequest): CheckInLicenseResponse {
        val op = SdkHttpOperation.build<CheckInLicenseRequest, CheckInLicenseResponse> {
            serializer = CheckInLicenseOperationSerializer()
            deserializer = CheckInLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CheckInLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Checks out the specified license for offline use.
     */
    override suspend fun checkoutBorrowLicense(input: CheckoutBorrowLicenseRequest): CheckoutBorrowLicenseResponse {
        val op = SdkHttpOperation.build<CheckoutBorrowLicenseRequest, CheckoutBorrowLicenseResponse> {
            serializer = CheckoutBorrowLicenseOperationSerializer()
            deserializer = CheckoutBorrowLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CheckoutBorrowLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Checks out the specified license.
     */
    override suspend fun checkoutLicense(input: CheckoutLicenseRequest): CheckoutLicenseResponse {
        val op = SdkHttpOperation.build<CheckoutLicenseRequest, CheckoutLicenseResponse> {
            serializer = CheckoutLicenseOperationSerializer()
            deserializer = CheckoutLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CheckoutLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a grant for the specified license. A grant shares the use of license entitlements with specific Amazon Web Services accounts.
     */
    override suspend fun createGrant(input: CreateGrantRequest): CreateGrantResponse {
        val op = SdkHttpOperation.build<CreateGrantRequest, CreateGrantResponse> {
            serializer = CreateGrantOperationSerializer()
            deserializer = CreateGrantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGrant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new version of the specified grant.
     */
    override suspend fun createGrantVersion(input: CreateGrantVersionRequest): CreateGrantVersionResponse {
        val op = SdkHttpOperation.build<CreateGrantVersionRequest, CreateGrantVersionResponse> {
            serializer = CreateGrantVersionOperationSerializer()
            deserializer = CreateGrantVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGrantVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a license.
     */
    override suspend fun createLicense(input: CreateLicenseRequest): CreateLicenseResponse {
        val op = SdkHttpOperation.build<CreateLicenseRequest, CreateLicenseResponse> {
            serializer = CreateLicenseOperationSerializer()
            deserializer = CreateLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a license configuration.
     *
     * A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to host (how long a license must be associated with a host), and the number of licenses purchased and used.
     */
    override suspend fun createLicenseConfiguration(input: CreateLicenseConfigurationRequest): CreateLicenseConfigurationResponse {
        val op = SdkHttpOperation.build<CreateLicenseConfigurationRequest, CreateLicenseConfigurationResponse> {
            serializer = CreateLicenseConfigurationOperationSerializer()
            deserializer = CreateLicenseConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLicenseConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new license conversion task.
     */
    override suspend fun createLicenseConversionTaskForResource(input: CreateLicenseConversionTaskForResourceRequest): CreateLicenseConversionTaskForResourceResponse {
        val op = SdkHttpOperation.build<CreateLicenseConversionTaskForResourceRequest, CreateLicenseConversionTaskForResourceResponse> {
            serializer = CreateLicenseConversionTaskForResourceOperationSerializer()
            deserializer = CreateLicenseConversionTaskForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLicenseConversionTaskForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a report generator.
     */
    override suspend fun createLicenseManagerReportGenerator(input: CreateLicenseManagerReportGeneratorRequest): CreateLicenseManagerReportGeneratorResponse {
        val op = SdkHttpOperation.build<CreateLicenseManagerReportGeneratorRequest, CreateLicenseManagerReportGeneratorResponse> {
            serializer = CreateLicenseManagerReportGeneratorOperationSerializer()
            deserializer = CreateLicenseManagerReportGeneratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLicenseManagerReportGenerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new version of the specified license.
     */
    override suspend fun createLicenseVersion(input: CreateLicenseVersionRequest): CreateLicenseVersionResponse {
        val op = SdkHttpOperation.build<CreateLicenseVersionRequest, CreateLicenseVersionResponse> {
            serializer = CreateLicenseVersionOperationSerializer()
            deserializer = CreateLicenseVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLicenseVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a long-lived token.
     *
     * A refresh token is a JWT token used to get an access token. With an access token, you can call AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the specified license.
     */
    override suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse {
        val op = SdkHttpOperation.build<CreateTokenRequest, CreateTokenResponse> {
            serializer = CreateTokenOperationSerializer()
            deserializer = CreateTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified grant.
     */
    override suspend fun deleteGrant(input: DeleteGrantRequest): DeleteGrantResponse {
        val op = SdkHttpOperation.build<DeleteGrantRequest, DeleteGrantResponse> {
            serializer = DeleteGrantOperationSerializer()
            deserializer = DeleteGrantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGrant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified license.
     */
    override suspend fun deleteLicense(input: DeleteLicenseRequest): DeleteLicenseResponse {
        val op = SdkHttpOperation.build<DeleteLicenseRequest, DeleteLicenseResponse> {
            serializer = DeleteLicenseOperationSerializer()
            deserializer = DeleteLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified license configuration.
     *
     * You cannot delete a license configuration that is in use.
     */
    override suspend fun deleteLicenseConfiguration(input: DeleteLicenseConfigurationRequest): DeleteLicenseConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteLicenseConfigurationRequest, DeleteLicenseConfigurationResponse> {
            serializer = DeleteLicenseConfigurationOperationSerializer()
            deserializer = DeleteLicenseConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLicenseConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified report generator.
     *
     * This action deletes the report generator, which stops it from generating future reports. The action cannot be reversed. It has no effect on the previous reports from this generator.
     */
    override suspend fun deleteLicenseManagerReportGenerator(input: DeleteLicenseManagerReportGeneratorRequest): DeleteLicenseManagerReportGeneratorResponse {
        val op = SdkHttpOperation.build<DeleteLicenseManagerReportGeneratorRequest, DeleteLicenseManagerReportGeneratorResponse> {
            serializer = DeleteLicenseManagerReportGeneratorOperationSerializer()
            deserializer = DeleteLicenseManagerReportGeneratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLicenseManagerReportGenerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified token. Must be called in the license home Region.
     */
    override suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse {
        val op = SdkHttpOperation.build<DeleteTokenRequest, DeleteTokenResponse> {
            serializer = DeleteTokenOperationSerializer()
            deserializer = DeleteTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Extends the expiration date for license consumption.
     */
    override suspend fun extendLicenseConsumption(input: ExtendLicenseConsumptionRequest): ExtendLicenseConsumptionResponse {
        val op = SdkHttpOperation.build<ExtendLicenseConsumptionRequest, ExtendLicenseConsumptionResponse> {
            serializer = ExtendLicenseConsumptionOperationSerializer()
            deserializer = ExtendLicenseConsumptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExtendLicenseConsumption"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
     */
    override suspend fun getAccessToken(input: GetAccessTokenRequest): GetAccessTokenResponse {
        val op = SdkHttpOperation.build<GetAccessTokenRequest, GetAccessTokenResponse> {
            serializer = GetAccessTokenOperationSerializer()
            deserializer = GetAccessTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccessToken"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets detailed information about the specified grant.
     */
    override suspend fun getGrant(input: GetGrantRequest): GetGrantResponse {
        val op = SdkHttpOperation.build<GetGrantRequest, GetGrantResponse> {
            serializer = GetGrantOperationSerializer()
            deserializer = GetGrantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetGrant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets detailed information about the specified license.
     */
    override suspend fun getLicense(input: GetLicenseRequest): GetLicenseResponse {
        val op = SdkHttpOperation.build<GetLicenseRequest, GetLicenseResponse> {
            serializer = GetLicenseOperationSerializer()
            deserializer = GetLicenseOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLicense"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets detailed information about the specified license configuration.
     */
    override suspend fun getLicenseConfiguration(input: GetLicenseConfigurationRequest): GetLicenseConfigurationResponse {
        val op = SdkHttpOperation.build<GetLicenseConfigurationRequest, GetLicenseConfigurationResponse> {
            serializer = GetLicenseConfigurationOperationSerializer()
            deserializer = GetLicenseConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLicenseConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified license type conversion task.
     */
    override suspend fun getLicenseConversionTask(input: GetLicenseConversionTaskRequest): GetLicenseConversionTaskResponse {
        val op = SdkHttpOperation.build<GetLicenseConversionTaskRequest, GetLicenseConversionTaskResponse> {
            serializer = GetLicenseConversionTaskOperationSerializer()
            deserializer = GetLicenseConversionTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLicenseConversionTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified report generator.
     */
    override suspend fun getLicenseManagerReportGenerator(input: GetLicenseManagerReportGeneratorRequest): GetLicenseManagerReportGeneratorResponse {
        val op = SdkHttpOperation.build<GetLicenseManagerReportGeneratorRequest, GetLicenseManagerReportGeneratorResponse> {
            serializer = GetLicenseManagerReportGeneratorOperationSerializer()
            deserializer = GetLicenseManagerReportGeneratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLicenseManagerReportGenerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets detailed information about the usage of the specified license.
     */
    override suspend fun getLicenseUsage(input: GetLicenseUsageRequest): GetLicenseUsageResponse {
        val op = SdkHttpOperation.build<GetLicenseUsageRequest, GetLicenseUsageResponse> {
            serializer = GetLicenseUsageOperationSerializer()
            deserializer = GetLicenseUsageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLicenseUsage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the License Manager settings for the current Region.
     */
    override suspend fun getServiceSettings(input: GetServiceSettingsRequest): GetServiceSettingsResponse {
        val op = SdkHttpOperation.build<GetServiceSettingsRequest, GetServiceSettingsResponse> {
            serializer = GetServiceSettingsOperationSerializer()
            deserializer = GetServiceSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resource associations for the specified license configuration.
     *
     * Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped instance might not consume a license (depending on the license rules).
     */
    override suspend fun listAssociationsForLicenseConfiguration(input: ListAssociationsForLicenseConfigurationRequest): ListAssociationsForLicenseConfigurationResponse {
        val op = SdkHttpOperation.build<ListAssociationsForLicenseConfigurationRequest, ListAssociationsForLicenseConfigurationResponse> {
            serializer = ListAssociationsForLicenseConfigurationOperationSerializer()
            deserializer = ListAssociationsForLicenseConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssociationsForLicenseConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the grants distributed for the specified license.
     */
    override suspend fun listDistributedGrants(input: ListDistributedGrantsRequest): ListDistributedGrantsResponse {
        val op = SdkHttpOperation.build<ListDistributedGrantsRequest, ListDistributedGrantsResponse> {
            serializer = ListDistributedGrantsOperationSerializer()
            deserializer = ListDistributedGrantsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDistributedGrants"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the license configuration operations that failed.
     */
    override suspend fun listFailuresForLicenseConfigurationOperations(input: ListFailuresForLicenseConfigurationOperationsRequest): ListFailuresForLicenseConfigurationOperationsResponse {
        val op = SdkHttpOperation.build<ListFailuresForLicenseConfigurationOperationsRequest, ListFailuresForLicenseConfigurationOperationsResponse> {
            serializer = ListFailuresForLicenseConfigurationOperationsOperationSerializer()
            deserializer = ListFailuresForLicenseConfigurationOperationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFailuresForLicenseConfigurationOperations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the license configurations for your account.
     */
    override suspend fun listLicenseConfigurations(input: ListLicenseConfigurationsRequest): ListLicenseConfigurationsResponse {
        val op = SdkHttpOperation.build<ListLicenseConfigurationsRequest, ListLicenseConfigurationsResponse> {
            serializer = ListLicenseConfigurationsOperationSerializer()
            deserializer = ListLicenseConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLicenseConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the license type conversion tasks for your account.
     */
    override suspend fun listLicenseConversionTasks(input: ListLicenseConversionTasksRequest): ListLicenseConversionTasksResponse {
        val op = SdkHttpOperation.build<ListLicenseConversionTasksRequest, ListLicenseConversionTasksResponse> {
            serializer = ListLicenseConversionTasksOperationSerializer()
            deserializer = ListLicenseConversionTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLicenseConversionTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the report generators for your account.
     */
    override suspend fun listLicenseManagerReportGenerators(input: ListLicenseManagerReportGeneratorsRequest): ListLicenseManagerReportGeneratorsResponse {
        val op = SdkHttpOperation.build<ListLicenseManagerReportGeneratorsRequest, ListLicenseManagerReportGeneratorsResponse> {
            serializer = ListLicenseManagerReportGeneratorsOperationSerializer()
            deserializer = ListLicenseManagerReportGeneratorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLicenseManagerReportGenerators"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the license configurations for the specified resource.
     */
    override suspend fun listLicenseSpecificationsForResource(input: ListLicenseSpecificationsForResourceRequest): ListLicenseSpecificationsForResourceResponse {
        val op = SdkHttpOperation.build<ListLicenseSpecificationsForResourceRequest, ListLicenseSpecificationsForResourceResponse> {
            serializer = ListLicenseSpecificationsForResourceOperationSerializer()
            deserializer = ListLicenseSpecificationsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLicenseSpecificationsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all versions of the specified license.
     */
    override suspend fun listLicenseVersions(input: ListLicenseVersionsRequest): ListLicenseVersionsResponse {
        val op = SdkHttpOperation.build<ListLicenseVersionsRequest, ListLicenseVersionsResponse> {
            serializer = ListLicenseVersionsOperationSerializer()
            deserializer = ListLicenseVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLicenseVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the licenses for your account.
     */
    override suspend fun listLicenses(input: ListLicensesRequest): ListLicensesResponse {
        val op = SdkHttpOperation.build<ListLicensesRequest, ListLicensesResponse> {
            serializer = ListLicensesOperationSerializer()
            deserializer = ListLicensesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLicenses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists grants that are received but not accepted.
     */
    override suspend fun listReceivedGrants(input: ListReceivedGrantsRequest): ListReceivedGrantsResponse {
        val op = SdkHttpOperation.build<ListReceivedGrantsRequest, ListReceivedGrantsResponse> {
            serializer = ListReceivedGrantsOperationSerializer()
            deserializer = ListReceivedGrantsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReceivedGrants"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists received licenses.
     */
    override suspend fun listReceivedLicenses(input: ListReceivedLicensesRequest): ListReceivedLicensesResponse {
        val op = SdkHttpOperation.build<ListReceivedLicensesRequest, ListReceivedLicensesResponse> {
            serializer = ListReceivedLicensesOperationSerializer()
            deserializer = ListReceivedLicensesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReceivedLicenses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists resources managed using Systems Manager inventory.
     */
    override suspend fun listResourceInventory(input: ListResourceInventoryRequest): ListResourceInventoryResponse {
        val op = SdkHttpOperation.build<ListResourceInventoryRequest, ListResourceInventoryResponse> {
            serializer = ListResourceInventoryOperationSerializer()
            deserializer = ListResourceInventoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResourceInventory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the specified license configuration.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your tokens.
     */
    override suspend fun listTokens(input: ListTokensRequest): ListTokensResponse {
        val op = SdkHttpOperation.build<ListTokensRequest, ListTokensResponse> {
            serializer = ListTokensOperationSerializer()
            deserializer = ListTokensOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTokens"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time. Use this action to audit the current license consumption for any license inventory and configuration.
     */
    override suspend fun listUsageForLicenseConfiguration(input: ListUsageForLicenseConfigurationRequest): ListUsageForLicenseConfigurationResponse {
        val op = SdkHttpOperation.build<ListUsageForLicenseConfigurationRequest, ListUsageForLicenseConfigurationResponse> {
            serializer = ListUsageForLicenseConfigurationOperationSerializer()
            deserializer = ListUsageForLicenseConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsageForLicenseConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects the specified grant.
     */
    override suspend fun rejectGrant(input: RejectGrantRequest): RejectGrantResponse {
        val op = SdkHttpOperation.build<RejectGrantRequest, RejectGrantResponse> {
            serializer = RejectGrantOperationSerializer()
            deserializer = RejectGrantOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectGrant"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tags to the specified license configuration.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified license configuration.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the attributes of an existing license configuration.
     */
    override suspend fun updateLicenseConfiguration(input: UpdateLicenseConfigurationRequest): UpdateLicenseConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateLicenseConfigurationRequest, UpdateLicenseConfigurationResponse> {
            serializer = UpdateLicenseConfigurationOperationSerializer()
            deserializer = UpdateLicenseConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLicenseConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a report generator.
     *
     * After you make changes to a report generator, it starts generating new reports within 60 minutes of being updated.
     */
    override suspend fun updateLicenseManagerReportGenerator(input: UpdateLicenseManagerReportGeneratorRequest): UpdateLicenseManagerReportGeneratorResponse {
        val op = SdkHttpOperation.build<UpdateLicenseManagerReportGeneratorRequest, UpdateLicenseManagerReportGeneratorResponse> {
            serializer = UpdateLicenseManagerReportGeneratorOperationSerializer()
            deserializer = UpdateLicenseManagerReportGeneratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLicenseManagerReportGenerator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or removes the specified license configurations for the specified Amazon Web Services resource.
     *
     * You can update the license specifications of AMIs, instances, and hosts. You cannot update the license specifications for launch templates and CloudFormation templates, as they send license configurations to the operation that creates the resource.
     */
    override suspend fun updateLicenseSpecificationsForResource(input: UpdateLicenseSpecificationsForResourceRequest): UpdateLicenseSpecificationsForResourceResponse {
        val op = SdkHttpOperation.build<UpdateLicenseSpecificationsForResourceRequest, UpdateLicenseSpecificationsForResourceResponse> {
            serializer = UpdateLicenseSpecificationsForResourceOperationSerializer()
            deserializer = UpdateLicenseSpecificationsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLicenseSpecificationsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates License Manager settings for the current Region.
     */
    override suspend fun updateServiceSettings(input: UpdateServiceSettingsRequest): UpdateServiceSettingsResponse {
        val op = SdkHttpOperation.build<UpdateServiceSettingsRequest, UpdateServiceSettingsResponse> {
            serializer = UpdateServiceSettingsOperationSerializer()
            deserializer = UpdateServiceSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateServiceSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSLicenseManager", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "license-manager"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "license-manager")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
