// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.serde

import aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContext
import aws.sdk.kotlin.services.lexruntimeservice.model.PostTextRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PostTextOperationSerializer: HttpSerialize<PostTextRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PostTextRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.botName) { "botName is bound to the URI and must not be null" }
            requireNotNull(input.botAlias) { "botAlias is bound to the URI and must not be null" }
            requireNotNull(input.userId) { "userId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("bot"))
                add(PercentEncoding.SmithyLabel.encode("${input.botName}"))
                add(PercentEncoding.Path.encode("alias"))
                add(PercentEncoding.SmithyLabel.encode("${input.botAlias}"))
                add(PercentEncoding.Path.encode("user"))
                add(PercentEncoding.SmithyLabel.encode("${input.userId}"))
                add(PercentEncoding.Path.encode("text"))
            }
        }

        val payload = serializePostTextOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePostTextOperationBody(context: ExecutionContext, input: PostTextRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIVECONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("activeContexts"))
    val INPUTTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("inputText"))
    val REQUESTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestAttributes"))
    val SESSIONATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("sessionAttributes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVECONTEXTS_DESCRIPTOR)
        field(INPUTTEXT_DESCRIPTOR)
        field(REQUESTATTRIBUTES_DESCRIPTOR)
        field(SESSIONATTRIBUTES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.activeContexts != null) {
            listField(ACTIVECONTEXTS_DESCRIPTOR) {
                for (el0 in input.activeContexts) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeActiveContextDocument))
                }
            }
        }
        input.inputText?.let { field(INPUTTEXT_DESCRIPTOR, it) }
        if (input.requestAttributes != null) {
            mapField(REQUESTATTRIBUTES_DESCRIPTOR) {
                input.requestAttributes.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.sessionAttributes != null) {
            mapField(SESSIONATTRIBUTES_DESCRIPTOR) {
                input.sessionAttributes.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
