// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.serde

import aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContext
import aws.sdk.kotlin.services.lexruntimeservice.model.DialogState
import aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence
import aws.sdk.kotlin.services.lexruntimeservice.model.LexRuntimeException
import aws.sdk.kotlin.services.lexruntimeservice.model.MessageFormatType
import aws.sdk.kotlin.services.lexruntimeservice.model.PostTextResponse
import aws.sdk.kotlin.services.lexruntimeservice.model.PredictedIntent
import aws.sdk.kotlin.services.lexruntimeservice.model.ResponseCard
import aws.sdk.kotlin.services.lexruntimeservice.model.SentimentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class PostTextOperationDeserializer: HttpDeserialize<PostTextResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PostTextResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostTextError(context, call)
        }
        val builder = PostTextResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePostTextOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPostTextError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "DependencyFailedException" -> DependencyFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "LoopDetectedException" -> LoopDetectedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePostTextOperationBody(builder: PostTextResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVECONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("activeContexts"))
    val ALTERNATIVEINTENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("alternativeIntents"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val DIALOGSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("dialogState"))
    val INTENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("intentName"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("message"))
    val MESSAGEFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("messageFormat"))
    val NLUINTENTCONFIDENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("nluIntentConfidence"))
    val RESPONSECARD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("responseCard"))
    val SENTIMENTRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sentimentResponse"))
    val SESSIONATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("sessionAttributes"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val SLOTTOELICIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotToElicit"))
    val SLOTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("slots"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVECONTEXTS_DESCRIPTOR)
        field(ALTERNATIVEINTENTS_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(DIALOGSTATE_DESCRIPTOR)
        field(INTENTNAME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(MESSAGEFORMAT_DESCRIPTOR)
        field(NLUINTENTCONFIDENCE_DESCRIPTOR)
        field(RESPONSECARD_DESCRIPTOR)
        field(SENTIMENTRESPONSE_DESCRIPTOR)
        field(SESSIONATTRIBUTES_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(SLOTTOELICIT_DESCRIPTOR)
        field(SLOTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVECONTEXTS_DESCRIPTOR.index -> builder.activeContexts =
                    deserializer.deserializeList(ACTIVECONTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ActiveContext>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActiveContextDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ALTERNATIVEINTENTS_DESCRIPTOR.index -> builder.alternativeIntents =
                    deserializer.deserializeList(ALTERNATIVEINTENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<PredictedIntent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePredictedIntentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                DIALOGSTATE_DESCRIPTOR.index -> builder.dialogState = deserializeString().let { DialogState.fromValue(it) }
                INTENTNAME_DESCRIPTOR.index -> builder.intentName = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                MESSAGEFORMAT_DESCRIPTOR.index -> builder.messageFormat = deserializeString().let { MessageFormatType.fromValue(it) }
                NLUINTENTCONFIDENCE_DESCRIPTOR.index -> builder.nluIntentConfidence = deserializeIntentConfidenceDocument(deserializer)
                RESPONSECARD_DESCRIPTOR.index -> builder.responseCard = deserializeResponseCardDocument(deserializer)
                SENTIMENTRESPONSE_DESCRIPTOR.index -> builder.sentimentResponse = deserializeSentimentResponseDocument(deserializer)
                SESSIONATTRIBUTES_DESCRIPTOR.index -> builder.sessionAttributes =
                    deserializer.deserializeMap(SESSIONATTRIBUTES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                SLOTTOELICIT_DESCRIPTOR.index -> builder.slotToElicit = deserializeString()
                SLOTS_DESCRIPTOR.index -> builder.slots =
                    deserializer.deserializeMap(SLOTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
