// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.serde

import aws.sdk.kotlin.services.lexruntimeservice.model.PostContentRequest
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.text.encoding.encodeBase64


internal class PostContentOperationSerializer: HttpSerialize<PostContentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PostContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.botName) { "botName is bound to the URI and must not be null" }
            requireNotNull(input.botAlias) { "botAlias is bound to the URI and must not be null" }
            requireNotNull(input.userId) { "userId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("bot"))
                add(PercentEncoding.SmithyLabel.encode("${input.botName}"))
                add(PercentEncoding.Path.encode("alias"))
                add(PercentEncoding.SmithyLabel.encode("${input.botAlias}"))
                add(PercentEncoding.Path.encode("user"))
                add(PercentEncoding.SmithyLabel.encode("${input.userId}"))
                add(PercentEncoding.Path.encode("content"))
            }
        }

        builder.headers {
            if (input.accept?.isNotEmpty() == true) append("Accept", input.accept)
            if (input.activeContexts?.isNotEmpty() == true) append("x-amz-lex-active-contexts", input.activeContexts.encodeBase64())
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
            if (input.requestAttributes?.isNotEmpty() == true) append("x-amz-lex-request-attributes", input.requestAttributes.encodeBase64())
            if (input.sessionAttributes?.isNotEmpty() == true) append("x-amz-lex-session-attributes", input.sessionAttributes.encodeBase64())
        }

        if (input.inputStream != null) {
            builder.body = input.inputStream.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.inputStream == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
