// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.serde

import aws.sdk.kotlin.services.lexruntimeservice.model.DialogState
import aws.sdk.kotlin.services.lexruntimeservice.model.LexRuntimeException
import aws.sdk.kotlin.services.lexruntimeservice.model.MessageFormatType
import aws.sdk.kotlin.services.lexruntimeservice.model.PostContentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.decodeBase64


internal class PostContentOperationDeserializer: HttpDeserialize<PostContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PostContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostContentError(context, call)
        }
        val builder = PostContentResponse.Builder()

        builder.activeContexts = response.headers["x-amz-lex-active-contexts"]?.decodeBase64()
        builder.alternativeIntents = response.headers["x-amz-lex-alternative-intents"]?.decodeBase64()
        builder.botVersion = response.headers["x-amz-lex-bot-version"]
        builder.contentType = response.headers["Content-Type"]
        builder.dialogState = response.headers["x-amz-lex-dialog-state"]?.let { DialogState.fromValue(it) }
        builder.encodedInputTranscript = response.headers["x-amz-lex-encoded-input-transcript"]
        builder.encodedMessage = response.headers["x-amz-lex-encoded-message"]
        builder.inputTranscript = response.headers["x-amz-lex-input-transcript"]
        builder.intentName = response.headers["x-amz-lex-intent-name"]
        builder.message = response.headers["x-amz-lex-message"]
        builder.messageFormat = response.headers["x-amz-lex-message-format"]?.let { MessageFormatType.fromValue(it) }
        builder.nluIntentConfidence = response.headers["x-amz-lex-nlu-intent-confidence"]?.decodeBase64()
        builder.sentimentResponse = response.headers["x-amz-lex-sentiment"]
        builder.sessionAttributes = response.headers["x-amz-lex-session-attributes"]?.decodeBase64()
        builder.sessionId = response.headers["x-amz-lex-session-id"]
        builder.slotToElicit = response.headers["x-amz-lex-slot-to-elicit"]
        builder.slots = response.headers["x-amz-lex-slots"]?.decodeBase64()

        builder.audioStream = response.body.toByteStream()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPostContentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedMediaTypeException" -> UnsupportedMediaTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "DependencyFailedException" -> DependencyFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "LoopDetectedException" -> LoopDetectedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestTimeoutException" -> RequestTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAcceptableException" -> NotAcceptableExceptionDeserializer().deserialize(context, wrappedCall)
        "BadGatewayException" -> BadGatewayExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
