// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.serde

import aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContext
import aws.sdk.kotlin.services.lexruntimeservice.model.DialogAction
import aws.sdk.kotlin.services.lexruntimeservice.model.GetSessionResponse
import aws.sdk.kotlin.services.lexruntimeservice.model.IntentSummary
import aws.sdk.kotlin.services.lexruntimeservice.model.LexRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetSessionOperationDeserializer: HttpDeserialize<GetSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSessionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSessionError(context, call)
        }
        val builder = GetSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSessionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSessionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSessionOperationBody(builder: GetSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVECONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("activeContexts"))
    val DIALOGACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dialogAction"))
    val RECENTINTENTSUMMARYVIEW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("recentIntentSummaryView"))
    val SESSIONATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("sessionAttributes"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVECONTEXTS_DESCRIPTOR)
        field(DIALOGACTION_DESCRIPTOR)
        field(RECENTINTENTSUMMARYVIEW_DESCRIPTOR)
        field(SESSIONATTRIBUTES_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVECONTEXTS_DESCRIPTOR.index -> builder.activeContexts =
                    deserializer.deserializeList(ACTIVECONTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ActiveContext>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActiveContextDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DIALOGACTION_DESCRIPTOR.index -> builder.dialogAction = deserializeDialogActionDocument(deserializer)
                RECENTINTENTSUMMARYVIEW_DESCRIPTOR.index -> builder.recentIntentSummaryView =
                    deserializer.deserializeList(RECENTINTENTSUMMARYVIEW_DESCRIPTOR) {
                        val col0 = mutableListOf<IntentSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIntentSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SESSIONATTRIBUTES_DESCRIPTOR.index -> builder.sessionAttributes =
                    deserializer.deserializeMap(SESSIONATTRIBUTES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
