// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.serde

import aws.sdk.kotlin.services.lexruntimeservice.model.DeleteSessionResponse
import aws.sdk.kotlin.services.lexruntimeservice.model.LexRuntimeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteSessionOperationDeserializer: HttpDeserialize<DeleteSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteSessionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteSessionError(context, call)
        }
        val builder = DeleteSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteSessionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteSessionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw LexRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> LexRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteSessionOperationBody(builder: DeleteSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAlias"))
    val BOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botName"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTALIAS_DESCRIPTOR)
        field(BOTNAME_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTALIAS_DESCRIPTOR.index -> builder.botAlias = deserializeString()
                BOTNAME_DESCRIPTOR.index -> builder.botName = deserializeString()
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
