// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.model



/**
 * An intent that Amazon Lex suggests satisfies the user's intent. Includes the name of the intent, the confidence that Amazon Lex has that the user's intent is satisfied, and the slots defined for the intent.
 */
public class PredictedIntent private constructor(builder: Builder) {
    /**
     * The name of the intent that Amazon Lex suggests satisfies the user's intent.
     */
    public val intentName: kotlin.String? = builder.intentName
    /**
     * Indicates how confident Amazon Lex is that an intent satisfies the user's intent.
     */
    public val nluIntentConfidence: aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence? = builder.nluIntentConfidence
    /**
     * The slot and slot values associated with the predicted intent.
     */
    public val slots: Map<String, String>? = builder.slots

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimeservice.model.PredictedIntent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PredictedIntent(")
        append("intentName=$intentName,")
        append("nluIntentConfidence=$nluIntentConfidence,")
        append("slots=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = intentName?.hashCode() ?: 0
        result = 31 * result + (nluIntentConfidence?.hashCode() ?: 0)
        result = 31 * result + (slots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PredictedIntent

        if (intentName != other.intentName) return false
        if (nluIntentConfidence != other.nluIntentConfidence) return false
        if (slots != other.slots) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimeservice.model.PredictedIntent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the intent that Amazon Lex suggests satisfies the user's intent.
         */
        public var intentName: kotlin.String? = null
        /**
         * Indicates how confident Amazon Lex is that an intent satisfies the user's intent.
         */
        public var nluIntentConfidence: aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence? = null
        /**
         * The slot and slot values associated with the predicted intent.
         */
        public var slots: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimeservice.model.PredictedIntent) : this() {
            this.intentName = x.intentName
            this.nluIntentConfidence = x.nluIntentConfidence
            this.slots = x.slots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimeservice.model.PredictedIntent = PredictedIntent(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence] inside the given [block]
         */
        public fun nluIntentConfidence(block: aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence.Builder.() -> kotlin.Unit) {
            this.nluIntentConfidence = aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
