// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.model



public class PostTextResponse private constructor(builder: Builder) {
    /**
     * A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the `PostContent`, `PostText`, or `PutSession` operation.
     *
     * You can use a context to control the intents that can follow up an intent, or to modify the operation of your application.
     */
    public val activeContexts: List<ActiveContext>? = builder.activeContexts
    /**
     * One to four alternative intents that may be applicable to the user's intent.
     *
     * Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the user's intent. The intents are sorted by the confidence score.
     */
    public val alternativeIntents: List<PredictedIntent>? = builder.alternativeIntents
    /**
     * The version of the bot that responded to the conversation. You can use this information to help determine if one version of a bot is performing better than another version.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as `dialogState`. The client can optionally use this information to customize the user interface.
     * + `ElicitIntent` - Amazon Lex wants to elicit user intent. For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent from this utterance, it will return this dialogState.
     * + `ConfirmIntent` - Amazon Lex is expecting a "yes" or "no" response.  For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or "no," a user might respond with additional information. For example, "yes, but make it thick crust pizza" or "no, I want to order a drink". Amazon Lex can process such additional information (in these examples, update the crust type slot value, or change intent from OrderPizza to OrderDrink).
     * + `ElicitSlot` - Amazon Lex is expecting a slot value for the current intent. For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately.
     * + `Fulfilled` - Conveys that the Lambda function configured for the intent has successfully fulfilled the intent.
     * + `ReadyForFulfillment` - Conveys that the client has to fulfill the intent.
     * + `Failed` - Conveys that the conversation with the user failed.  This can happen for various reasons including that the user did not provide an appropriate response to prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or the Lambda function failed to fulfill the intent.
     */
    public val dialogState: aws.sdk.kotlin.services.lexruntimeservice.model.DialogState? = builder.dialogState
    /**
     * The current user intent that Amazon Lex is aware of.
     */
    public val intentName: kotlin.String? = builder.intentName
    /**
     * The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.
     *
     * If the intent is not configured with a Lambda function, or if the Lambda function returned `Delegate` as the `dialogAction.type` its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.
     *
     * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see msg-prompts-formats.
     *
     * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The format of the response message. One of the following values:
     * + `PlainText` - The message contains plain UTF-8 text.
     * + `CustomPayload` - The message is a custom format defined by the Lambda function.
     * + `SSML` - The message contains text formatted for voice output.
     * + `Composite` - The message contains an escaped JSON object containing one or more messages from the groups that messages were assigned to when the intent was created.
     */
    public val messageFormat: aws.sdk.kotlin.services.lexruntimeservice.model.MessageFormatType? = builder.messageFormat
    /**
     * Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches the user's intent. The score is between 0.0 and 1.0. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html).
     *
     * The score is a relative score, not an absolute score. The score may change based on improvements to Amazon Lex.
     */
    public val nluIntentConfidence: aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence? = builder.nluIntentConfidence
    /**
     * Represents the options that the user has to respond to the current prompt. Response Card can come from the bot configuration (in the Amazon Lex console, choose the settings button next to a slot) or from a code hook (Lambda function).
     */
    public val responseCard: aws.sdk.kotlin.services.lexruntimeservice.model.ResponseCard? = builder.responseCard
    /**
     * The sentiment expressed in and utterance.
     *
     * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.
     */
    public val sentimentResponse: aws.sdk.kotlin.services.lexruntimeservice.model.SentimentResponse? = builder.sentimentResponse
    /**
     * A map of key-value pairs representing the session-specific context information.
     */
    public val sessionAttributes: Map<String, String>? = builder.sessionAttributes
    /**
     * A unique identifier for the session.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * If the `dialogState` value is `ElicitSlot`, returns the name of the slot for which Amazon Lex is eliciting a value.
     */
    public val slotToElicit: kotlin.String? = builder.slotToElicit
    /**
     * The intent slots that Amazon Lex detected from the user input in the conversation.
     *
     * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined by the `valueSelectionStrategy` selected when the slot type was created or updated. If `valueSelectionStrategy` is set to `ORIGINAL_VALUE`, the value provided by the user is returned, if the user value is similar to the slot values. If `valueSelectionStrategy` is set to `TOP_RESOLUTION` Amazon Lex returns the first value in the resolution list or, if there is no resolution list, null. If you don't specify a `valueSelectionStrategy`, the default is `ORIGINAL_VALUE`.
     */
    public val slots: Map<String, String>? = builder.slots

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimeservice.model.PostTextResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PostTextResponse(")
        append("activeContexts=*** Sensitive Data Redacted ***,")
        append("alternativeIntents=$alternativeIntents,")
        append("botVersion=$botVersion,")
        append("dialogState=$dialogState,")
        append("intentName=$intentName,")
        append("message=*** Sensitive Data Redacted ***,")
        append("messageFormat=$messageFormat,")
        append("nluIntentConfidence=$nluIntentConfidence,")
        append("responseCard=$responseCard,")
        append("sentimentResponse=$sentimentResponse,")
        append("sessionAttributes=*** Sensitive Data Redacted ***,")
        append("sessionId=$sessionId,")
        append("slotToElicit=$slotToElicit,")
        append("slots=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeContexts?.hashCode() ?: 0
        result = 31 * result + (alternativeIntents?.hashCode() ?: 0)
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (dialogState?.hashCode() ?: 0)
        result = 31 * result + (intentName?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (messageFormat?.hashCode() ?: 0)
        result = 31 * result + (nluIntentConfidence?.hashCode() ?: 0)
        result = 31 * result + (responseCard?.hashCode() ?: 0)
        result = 31 * result + (sentimentResponse?.hashCode() ?: 0)
        result = 31 * result + (sessionAttributes?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (slotToElicit?.hashCode() ?: 0)
        result = 31 * result + (slots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PostTextResponse

        if (activeContexts != other.activeContexts) return false
        if (alternativeIntents != other.alternativeIntents) return false
        if (botVersion != other.botVersion) return false
        if (dialogState != other.dialogState) return false
        if (intentName != other.intentName) return false
        if (message != other.message) return false
        if (messageFormat != other.messageFormat) return false
        if (nluIntentConfidence != other.nluIntentConfidence) return false
        if (responseCard != other.responseCard) return false
        if (sentimentResponse != other.sentimentResponse) return false
        if (sessionAttributes != other.sessionAttributes) return false
        if (sessionId != other.sessionId) return false
        if (slotToElicit != other.slotToElicit) return false
        if (slots != other.slots) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimeservice.model.PostTextResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the `PostContent`, `PostText`, or `PutSession` operation.
         *
         * You can use a context to control the intents that can follow up an intent, or to modify the operation of your application.
         */
        public var activeContexts: List<ActiveContext>? = null
        /**
         * One to four alternative intents that may be applicable to the user's intent.
         *
         * Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the user's intent. The intents are sorted by the confidence score.
         */
        public var alternativeIntents: List<PredictedIntent>? = null
        /**
         * The version of the bot that responded to the conversation. You can use this information to help determine if one version of a bot is performing better than another version.
         */
        public var botVersion: kotlin.String? = null
        /**
         * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as `dialogState`. The client can optionally use this information to customize the user interface.
         * + `ElicitIntent` - Amazon Lex wants to elicit user intent. For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent from this utterance, it will return this dialogState.
         * + `ConfirmIntent` - Amazon Lex is expecting a "yes" or "no" response.  For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or "no," a user might respond with additional information. For example, "yes, but make it thick crust pizza" or "no, I want to order a drink". Amazon Lex can process such additional information (in these examples, update the crust type slot value, or change intent from OrderPizza to OrderDrink).
         * + `ElicitSlot` - Amazon Lex is expecting a slot value for the current intent. For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately.
         * + `Fulfilled` - Conveys that the Lambda function configured for the intent has successfully fulfilled the intent.
         * + `ReadyForFulfillment` - Conveys that the client has to fulfill the intent.
         * + `Failed` - Conveys that the conversation with the user failed.  This can happen for various reasons including that the user did not provide an appropriate response to prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or the Lambda function failed to fulfill the intent.
         */
        public var dialogState: aws.sdk.kotlin.services.lexruntimeservice.model.DialogState? = null
        /**
         * The current user intent that Amazon Lex is aware of.
         */
        public var intentName: kotlin.String? = null
        /**
         * The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.
         *
         * If the intent is not configured with a Lambda function, or if the Lambda function returned `Delegate` as the `dialogAction.type` its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.
         *
         * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see msg-prompts-formats.
         *
         * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
         */
        public var message: kotlin.String? = null
        /**
         * The format of the response message. One of the following values:
         * + `PlainText` - The message contains plain UTF-8 text.
         * + `CustomPayload` - The message is a custom format defined by the Lambda function.
         * + `SSML` - The message contains text formatted for voice output.
         * + `Composite` - The message contains an escaped JSON object containing one or more messages from the groups that messages were assigned to when the intent was created.
         */
        public var messageFormat: aws.sdk.kotlin.services.lexruntimeservice.model.MessageFormatType? = null
        /**
         * Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches the user's intent. The score is between 0.0 and 1.0. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html).
         *
         * The score is a relative score, not an absolute score. The score may change based on improvements to Amazon Lex.
         */
        public var nluIntentConfidence: aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence? = null
        /**
         * Represents the options that the user has to respond to the current prompt. Response Card can come from the bot configuration (in the Amazon Lex console, choose the settings button next to a slot) or from a code hook (Lambda function).
         */
        public var responseCard: aws.sdk.kotlin.services.lexruntimeservice.model.ResponseCard? = null
        /**
         * The sentiment expressed in and utterance.
         *
         * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.
         */
        public var sentimentResponse: aws.sdk.kotlin.services.lexruntimeservice.model.SentimentResponse? = null
        /**
         * A map of key-value pairs representing the session-specific context information.
         */
        public var sessionAttributes: Map<String, String>? = null
        /**
         * A unique identifier for the session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * If the `dialogState` value is `ElicitSlot`, returns the name of the slot for which Amazon Lex is eliciting a value.
         */
        public var slotToElicit: kotlin.String? = null
        /**
         * The intent slots that Amazon Lex detected from the user input in the conversation.
         *
         * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined by the `valueSelectionStrategy` selected when the slot type was created or updated. If `valueSelectionStrategy` is set to `ORIGINAL_VALUE`, the value provided by the user is returned, if the user value is similar to the slot values. If `valueSelectionStrategy` is set to `TOP_RESOLUTION` Amazon Lex returns the first value in the resolution list or, if there is no resolution list, null. If you don't specify a `valueSelectionStrategy`, the default is `ORIGINAL_VALUE`.
         */
        public var slots: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimeservice.model.PostTextResponse) : this() {
            this.activeContexts = x.activeContexts
            this.alternativeIntents = x.alternativeIntents
            this.botVersion = x.botVersion
            this.dialogState = x.dialogState
            this.intentName = x.intentName
            this.message = x.message
            this.messageFormat = x.messageFormat
            this.nluIntentConfidence = x.nluIntentConfidence
            this.responseCard = x.responseCard
            this.sentimentResponse = x.sentimentResponse
            this.sessionAttributes = x.sessionAttributes
            this.sessionId = x.sessionId
            this.slotToElicit = x.slotToElicit
            this.slots = x.slots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimeservice.model.PostTextResponse = PostTextResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence] inside the given [block]
         */
        public fun nluIntentConfidence(block: aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence.Builder.() -> kotlin.Unit) {
            this.nluIntentConfidence = aws.sdk.kotlin.services.lexruntimeservice.model.IntentConfidence.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimeservice.model.ResponseCard] inside the given [block]
         */
        public fun responseCard(block: aws.sdk.kotlin.services.lexruntimeservice.model.ResponseCard.Builder.() -> kotlin.Unit) {
            this.responseCard = aws.sdk.kotlin.services.lexruntimeservice.model.ResponseCard.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimeservice.model.SentimentResponse] inside the given [block]
         */
        public fun sentimentResponse(block: aws.sdk.kotlin.services.lexruntimeservice.model.SentimentResponse.Builder.() -> kotlin.Unit) {
            this.sentimentResponse = aws.sdk.kotlin.services.lexruntimeservice.model.SentimentResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
