// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.model



public class PostTextRequest private constructor(builder: Builder) {
    /**
     * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,
     *
     * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.
     */
    public val activeContexts: List<ActiveContext>? = builder.activeContexts
    /**
     * The alias of the Amazon Lex bot.
     */
    public val botAlias: kotlin.String? = builder.botAlias
    /**
     * The name of the Amazon Lex bot.
     */
    public val botName: kotlin.String? = builder.botName
    /**
     * The text that the user entered (Amazon Lex interprets this text).
     */
    public val inputText: kotlin.String? = builder.inputText
    /**
     * Request-specific information passed between Amazon Lex and a client application.
     *
     * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes with the prefix `x-amz-lex:`.
     *
     * For more information, see [Setting Request Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
     */
    public val requestAttributes: Map<String, String>? = builder.requestAttributes
    /**
     * Application-specific information passed between Amazon Lex and a client application.
     *
     * For more information, see [Setting Session Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
     */
    public val sessionAttributes: Map<String, String>? = builder.sessionAttributes
    /**
     * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the `userID` field.
     *
     * To decide the user ID to use for your application, consider the following factors.
     * + The `userID` field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.
     * + If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.
     * + If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.
     * + A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimeservice.model.PostTextRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PostTextRequest(")
        append("activeContexts=*** Sensitive Data Redacted ***,")
        append("botAlias=$botAlias,")
        append("botName=$botName,")
        append("inputText=*** Sensitive Data Redacted ***,")
        append("requestAttributes=*** Sensitive Data Redacted ***,")
        append("sessionAttributes=*** Sensitive Data Redacted ***,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeContexts?.hashCode() ?: 0
        result = 31 * result + (botAlias?.hashCode() ?: 0)
        result = 31 * result + (botName?.hashCode() ?: 0)
        result = 31 * result + (inputText?.hashCode() ?: 0)
        result = 31 * result + (requestAttributes?.hashCode() ?: 0)
        result = 31 * result + (sessionAttributes?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PostTextRequest

        if (activeContexts != other.activeContexts) return false
        if (botAlias != other.botAlias) return false
        if (botName != other.botName) return false
        if (inputText != other.inputText) return false
        if (requestAttributes != other.requestAttributes) return false
        if (sessionAttributes != other.sessionAttributes) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimeservice.model.PostTextRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,
         *
         * If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.
         */
        public var activeContexts: List<ActiveContext>? = null
        /**
         * The alias of the Amazon Lex bot.
         */
        public var botAlias: kotlin.String? = null
        /**
         * The name of the Amazon Lex bot.
         */
        public var botName: kotlin.String? = null
        /**
         * The text that the user entered (Amazon Lex interprets this text).
         */
        public var inputText: kotlin.String? = null
        /**
         * Request-specific information passed between Amazon Lex and a client application.
         *
         * The namespace `x-amz-lex:` is reserved for special attributes. Don't create any request attributes with the prefix `x-amz-lex:`.
         *
         * For more information, see [Setting Request Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
         */
        public var requestAttributes: Map<String, String>? = null
        /**
         * Application-specific information passed between Amazon Lex and a client application.
         *
         * For more information, see [Setting Session Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
         */
        public var sessionAttributes: Map<String, String>? = null
        /**
         * The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the `userID` field.
         *
         * To decide the user ID to use for your application, consider the following factors.
         * + The `userID` field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.
         * + If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.
         * + If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.
         * + A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimeservice.model.PostTextRequest) : this() {
            this.activeContexts = x.activeContexts
            this.botAlias = x.botAlias
            this.botName = x.botName
            this.inputText = x.inputText
            this.requestAttributes = x.requestAttributes
            this.sessionAttributes = x.sessionAttributes
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimeservice.model.PostTextRequest = PostTextRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
