// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.model

import aws.smithy.kotlin.runtime.content.ByteStream

public class PostContentResponse private constructor(builder: Builder) {
    /**
     * A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the `PostContent`, `PostText`, or `PutSession` operation.
     *
     * You can use a context to control the intents that can follow up an intent, or to modify the operation of your application.
     */
    public val activeContexts: kotlin.String? = builder.activeContexts
    /**
     * One to four alternative intents that may be applicable to the user's intent.
     *
     * Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the user's intent. The intents are sorted by the confidence score.
     */
    public val alternativeIntents: kotlin.String? = builder.alternativeIntents
    /**
     * The prompt (or statement) to convey to the user. This is based on the bot configuration and context. For example, if Amazon Lex did not understand the user intent, it sends the `clarificationPrompt` configured for the bot. If the intent requires confirmation before taking the fulfillment action, it sends the `confirmationPrompt`. Another example: Suppose that the Lambda function successfully fulfilled the intent, and sent a message to convey to the user. Then Amazon Lex sends that message in the response.
     */
    public val audioStream: aws.smithy.kotlin.runtime.content.ByteStream? = builder.audioStream
    /**
     * The version of the bot that responded to the conversation. You can use this information to help determine if one version of a bot is performing better than another version.
     */
    public val botVersion: kotlin.String? = builder.botVersion
    /**
     * Content type as specified in the `Accept` HTTP header in the request.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as `dialogState`. The client can optionally use this information to customize the user interface.
     * + `ElicitIntent` - Amazon Lex wants to elicit the user's intent. Consider the following examples:  For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent from this utterance, it will return this dialog state.
     * + `ConfirmIntent` - Amazon Lex is expecting a "yes" or "no" response. For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or "no" response, a user might respond with additional information. For example, "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such additional information (in these examples, update the crust type slot or change the intent from OrderPizza to OrderDrink).
     * + `ElicitSlot` - Amazon Lex is expecting the value of a slot for the current intent.  For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately.
     * + `Fulfilled` - Conveys that the Lambda function has successfully fulfilled the intent.
     * + `ReadyForFulfillment` - Conveys that the client has to fulfill the request.
     * + `Failed` - Conveys that the conversation with the user failed.  This can happen for various reasons, including that the user does not provide an appropriate response to prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or if the Lambda function fails to fulfill the intent.
     */
    public val dialogState: aws.sdk.kotlin.services.lexruntimeservice.model.DialogState? = builder.dialogState
    /**
     * The text used to process the request.
     *
     * If the input was an audio stream, the `encodedInputTranscript` field contains the text extracted from the audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this information to determine if Amazon Lex is correctly processing the audio that you send.
     *
     * The `encodedInputTranscript` field is base-64 encoded. You must decode the field before you can use the value.
     */
    public val encodedInputTranscript: kotlin.String? = builder.encodedInputTranscript
    /**
     * The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.
     *
     * If the intent is not configured with a Lambda function, or if the Lambda function returned `Delegate` as the `dialogAction.type` in its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.
     *
     * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see msg-prompts-formats.
     *
     * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
     *
     * The `encodedMessage` field is base-64 encoded. You must decode the field before you can use the value.
     */
    public val encodedMessage: kotlin.String? = builder.encodedMessage
    /**
     * The text used to process the request.
     *
     * You can use this field only in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the `inputTranscript` field is null. You should use the `encodedInputTranscript` field instead.
     *
     * If the input was an audio stream, the `inputTranscript` field contains the text extracted from the audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this information to determine if Amazon Lex is correctly processing the audio that you send.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val inputTranscript: kotlin.String? = builder.inputTranscript
    /**
     * Current user intent that Amazon Lex is aware of.
     */
    public val intentName: kotlin.String? = builder.intentName
    /**
     * You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the `message` field is null. You should use the `encodedMessage` field instead.
     *
     * The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.
     *
     * If the intent is not configured with a Lambda function, or if the Lambda function returned `Delegate` as the `dialogAction.type` in its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.
     *
     * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see msg-prompts-formats.
     *
     * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val message: kotlin.String? = builder.message
    /**
     * The format of the response message. One of the following values:
     * + `PlainText` - The message contains plain UTF-8 text.
     * + `CustomPayload` - The message is a custom format for the client.
     * + `SSML` - The message contains text formatted for voice output.
     * + `Composite` - The message contains an escaped JSON object containing one or more messages from the groups that messages were assigned to when the intent was created.
     */
    public val messageFormat: aws.sdk.kotlin.services.lexruntimeservice.model.MessageFormatType? = builder.messageFormat
    /**
     * Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches the user's intent. The score is between 0.0 and 1.0.
     *
     * The score is a relative score, not an absolute score. The score may change based on improvements to Amazon Lex.
     */
    public val nluIntentConfidence: kotlin.String? = builder.nluIntentConfidence
    /**
     * The sentiment expressed in an utterance.
     *
     * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.
     */
    public val sentimentResponse: kotlin.String? = builder.sentimentResponse
    /**
     * Map of key/value pairs representing the session-specific context information.
     */
    public val sessionAttributes: kotlin.String? = builder.sessionAttributes
    /**
     * The unique identifier for the session.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * If the `dialogState` value is `ElicitSlot`, returns the name of the slot for which Amazon Lex is eliciting a value.
     */
    public val slotToElicit: kotlin.String? = builder.slotToElicit
    /**
     * Map of zero or more intent slots (name/value pairs) Amazon Lex detected from the user input during the conversation. The field is base-64 encoded.
     *
     * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined by the `valueSelectionStrategy` selected when the slot type was created or updated. If `valueSelectionStrategy` is set to `ORIGINAL_VALUE`, the value provided by the user is returned, if the user value is similar to the slot values. If `valueSelectionStrategy` is set to `TOP_RESOLUTION` Amazon Lex returns the first value in the resolution list or, if there is no resolution list, null. If you don't specify a `valueSelectionStrategy`, the default is `ORIGINAL_VALUE`.
     */
    public val slots: kotlin.String? = builder.slots

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimeservice.model.PostContentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PostContentResponse(")
        append("activeContexts=*** Sensitive Data Redacted ***,")
        append("alternativeIntents=$alternativeIntents,")
        append("audioStream=$audioStream,")
        append("botVersion=$botVersion,")
        append("contentType=$contentType,")
        append("dialogState=$dialogState,")
        append("encodedInputTranscript=*** Sensitive Data Redacted ***,")
        append("encodedMessage=*** Sensitive Data Redacted ***,")
        append("inputTranscript=$inputTranscript,")
        append("intentName=$intentName,")
        append("message=*** Sensitive Data Redacted ***,")
        append("messageFormat=$messageFormat,")
        append("nluIntentConfidence=$nluIntentConfidence,")
        append("sentimentResponse=$sentimentResponse,")
        append("sessionAttributes=$sessionAttributes,")
        append("sessionId=$sessionId,")
        append("slotToElicit=$slotToElicit,")
        append("slots=$slots")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeContexts?.hashCode() ?: 0
        result = 31 * result + (alternativeIntents?.hashCode() ?: 0)
        result = 31 * result + (audioStream?.hashCode() ?: 0)
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (dialogState?.hashCode() ?: 0)
        result = 31 * result + (encodedInputTranscript?.hashCode() ?: 0)
        result = 31 * result + (encodedMessage?.hashCode() ?: 0)
        result = 31 * result + (inputTranscript?.hashCode() ?: 0)
        result = 31 * result + (intentName?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (messageFormat?.hashCode() ?: 0)
        result = 31 * result + (nluIntentConfidence?.hashCode() ?: 0)
        result = 31 * result + (sentimentResponse?.hashCode() ?: 0)
        result = 31 * result + (sessionAttributes?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (slotToElicit?.hashCode() ?: 0)
        result = 31 * result + (slots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PostContentResponse

        if (activeContexts != other.activeContexts) return false
        if (alternativeIntents != other.alternativeIntents) return false
        if (audioStream != other.audioStream) return false
        if (botVersion != other.botVersion) return false
        if (contentType != other.contentType) return false
        if (dialogState != other.dialogState) return false
        if (encodedInputTranscript != other.encodedInputTranscript) return false
        if (encodedMessage != other.encodedMessage) return false
        if (inputTranscript != other.inputTranscript) return false
        if (intentName != other.intentName) return false
        if (message != other.message) return false
        if (messageFormat != other.messageFormat) return false
        if (nluIntentConfidence != other.nluIntentConfidence) return false
        if (sentimentResponse != other.sentimentResponse) return false
        if (sessionAttributes != other.sessionAttributes) return false
        if (sessionId != other.sessionId) return false
        if (slotToElicit != other.slotToElicit) return false
        if (slots != other.slots) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimeservice.model.PostContentResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the `PostContent`, `PostText`, or `PutSession` operation.
         *
         * You can use a context to control the intents that can follow up an intent, or to modify the operation of your application.
         */
        public var activeContexts: kotlin.String? = null
        /**
         * One to four alternative intents that may be applicable to the user's intent.
         *
         * Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the user's intent. The intents are sorted by the confidence score.
         */
        public var alternativeIntents: kotlin.String? = null
        /**
         * The prompt (or statement) to convey to the user. This is based on the bot configuration and context. For example, if Amazon Lex did not understand the user intent, it sends the `clarificationPrompt` configured for the bot. If the intent requires confirmation before taking the fulfillment action, it sends the `confirmationPrompt`. Another example: Suppose that the Lambda function successfully fulfilled the intent, and sent a message to convey to the user. Then Amazon Lex sends that message in the response.
         */
        public var audioStream: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * The version of the bot that responded to the conversation. You can use this information to help determine if one version of a bot is performing better than another version.
         */
        public var botVersion: kotlin.String? = null
        /**
         * Content type as specified in the `Accept` HTTP header in the request.
         */
        public var contentType: kotlin.String? = null
        /**
         * Identifies the current state of the user interaction. Amazon Lex returns one of the following values as `dialogState`. The client can optionally use this information to customize the user interface.
         * + `ElicitIntent` - Amazon Lex wants to elicit the user's intent. Consider the following examples:  For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent from this utterance, it will return this dialog state.
         * + `ConfirmIntent` - Amazon Lex is expecting a "yes" or "no" response. For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or "no" response, a user might respond with additional information. For example, "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such additional information (in these examples, update the crust type slot or change the intent from OrderPizza to OrderDrink).
         * + `ElicitSlot` - Amazon Lex is expecting the value of a slot for the current intent.  For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately.
         * + `Fulfilled` - Conveys that the Lambda function has successfully fulfilled the intent.
         * + `ReadyForFulfillment` - Conveys that the client has to fulfill the request.
         * + `Failed` - Conveys that the conversation with the user failed.  This can happen for various reasons, including that the user does not provide an appropriate response to prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or if the Lambda function fails to fulfill the intent.
         */
        public var dialogState: aws.sdk.kotlin.services.lexruntimeservice.model.DialogState? = null
        /**
         * The text used to process the request.
         *
         * If the input was an audio stream, the `encodedInputTranscript` field contains the text extracted from the audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this information to determine if Amazon Lex is correctly processing the audio that you send.
         *
         * The `encodedInputTranscript` field is base-64 encoded. You must decode the field before you can use the value.
         */
        public var encodedInputTranscript: kotlin.String? = null
        /**
         * The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.
         *
         * If the intent is not configured with a Lambda function, or if the Lambda function returned `Delegate` as the `dialogAction.type` in its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.
         *
         * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see msg-prompts-formats.
         *
         * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
         *
         * The `encodedMessage` field is base-64 encoded. You must decode the field before you can use the value.
         */
        public var encodedMessage: kotlin.String? = null
        /**
         * The text used to process the request.
         *
         * You can use this field only in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the `inputTranscript` field is null. You should use the `encodedInputTranscript` field instead.
         *
         * If the input was an audio stream, the `inputTranscript` field contains the text extracted from the audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this information to determine if Amazon Lex is correctly processing the audio that you send.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var inputTranscript: kotlin.String? = null
        /**
         * Current user intent that Amazon Lex is aware of.
         */
        public var intentName: kotlin.String? = null
        /**
         * You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the `message` field is null. You should use the `encodedMessage` field instead.
         *
         * The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.
         *
         * If the intent is not configured with a Lambda function, or if the Lambda function returned `Delegate` as the `dialogAction.type` in its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.
         *
         * When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see msg-prompts-formats.
         *
         * If the Lambda function returns a message, Amazon Lex passes it to the client in its response.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var message: kotlin.String? = null
        /**
         * The format of the response message. One of the following values:
         * + `PlainText` - The message contains plain UTF-8 text.
         * + `CustomPayload` - The message is a custom format for the client.
         * + `SSML` - The message contains text formatted for voice output.
         * + `Composite` - The message contains an escaped JSON object containing one or more messages from the groups that messages were assigned to when the intent was created.
         */
        public var messageFormat: aws.sdk.kotlin.services.lexruntimeservice.model.MessageFormatType? = null
        /**
         * Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches the user's intent. The score is between 0.0 and 1.0.
         *
         * The score is a relative score, not an absolute score. The score may change based on improvements to Amazon Lex.
         */
        public var nluIntentConfidence: kotlin.String? = null
        /**
         * The sentiment expressed in an utterance.
         *
         * When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.
         */
        public var sentimentResponse: kotlin.String? = null
        /**
         * Map of key/value pairs representing the session-specific context information.
         */
        public var sessionAttributes: kotlin.String? = null
        /**
         * The unique identifier for the session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * If the `dialogState` value is `ElicitSlot`, returns the name of the slot for which Amazon Lex is eliciting a value.
         */
        public var slotToElicit: kotlin.String? = null
        /**
         * Map of zero or more intent slots (name/value pairs) Amazon Lex detected from the user input during the conversation. The field is base-64 encoded.
         *
         * Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined by the `valueSelectionStrategy` selected when the slot type was created or updated. If `valueSelectionStrategy` is set to `ORIGINAL_VALUE`, the value provided by the user is returned, if the user value is similar to the slot values. If `valueSelectionStrategy` is set to `TOP_RESOLUTION` Amazon Lex returns the first value in the resolution list or, if there is no resolution list, null. If you don't specify a `valueSelectionStrategy`, the default is `ORIGINAL_VALUE`.
         */
        public var slots: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimeservice.model.PostContentResponse) : this() {
            this.activeContexts = x.activeContexts
            this.alternativeIntents = x.alternativeIntents
            this.audioStream = x.audioStream
            this.botVersion = x.botVersion
            this.contentType = x.contentType
            this.dialogState = x.dialogState
            this.encodedInputTranscript = x.encodedInputTranscript
            this.encodedMessage = x.encodedMessage
            this.inputTranscript = x.inputTranscript
            this.intentName = x.intentName
            this.message = x.message
            this.messageFormat = x.messageFormat
            this.nluIntentConfidence = x.nluIntentConfidence
            this.sentimentResponse = x.sentimentResponse
            this.sessionAttributes = x.sessionAttributes
            this.sessionId = x.sessionId
            this.slotToElicit = x.slotToElicit
            this.slots = x.slots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimeservice.model.PostContentResponse = PostContentResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
