// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.model



/**
 * Provides information about the state of an intent. You can use this information to get the current state of an intent so that you can process the intent, or so that you can return the intent to its previous state.
 */
public class IntentSummary private constructor(builder: Builder) {
    /**
     * A user-defined label that identifies a particular intent. You can use this label to return to a previous intent.
     *
     * Use the `checkpointLabelFilter` parameter of the `GetSessionRequest` operation to filter the intents returned by the operation to those with only the specified label.
     */
    public val checkpointLabel: kotlin.String? = builder.checkpointLabel
    /**
     * The status of the intent after the user responds to the confirmation prompt. If the user confirms the intent, Amazon Lex sets this field to `Confirmed`. If the user denies the intent, Amazon Lex sets this value to `Denied`. The possible values are:
     * + `Confirmed` - The user has responded "Yes" to the confirmation prompt, confirming that the intent is complete and that it is ready to be fulfilled.
     * + `Denied` - The user has responded "No" to the confirmation prompt.
     * + `None` - The user has never been prompted for confirmation; or, the user was prompted but did not confirm or deny the prompt.
     */
    public val confirmationStatus: aws.sdk.kotlin.services.lexruntimeservice.model.ConfirmationStatus? = builder.confirmationStatus
    /**
     * The next action that the bot should take in its interaction with the user. The possible values are:
     * + `ConfirmIntent` - The next action is asking the user if the intent is complete and ready to be fulfilled. This is a yes/no question such as "Place the order?"
     * + `Close` - Indicates that the there will not be a response from the user. For example, the statement "Your order has been placed" does not require a response.
     * + `ElicitIntent` - The next action is to determine the intent that the user wants to fulfill.
     * + `ElicitSlot` - The next action is to elicit a slot value from the user.
     */
    public val dialogActionType: aws.sdk.kotlin.services.lexruntimeservice.model.DialogActionType = requireNotNull(builder.dialogActionType) { "A non-null value must be provided for dialogActionType" }
    /**
     * The fulfillment state of the intent. The possible values are:
     * + `Failed` - The Lambda function associated with the intent failed to fulfill the intent.
     * + `Fulfilled` - The intent has fulfilled by the Lambda function associated with the intent.
     * + `ReadyForFulfillment` - All of the information necessary for the intent is present and the intent ready to be fulfilled by the client application.
     */
    public val fulfillmentState: aws.sdk.kotlin.services.lexruntimeservice.model.FulfillmentState? = builder.fulfillmentState
    /**
     * The name of the intent.
     */
    public val intentName: kotlin.String? = builder.intentName
    /**
     * The next slot to elicit from the user. If there is not slot to elicit, the field is blank.
     */
    public val slotToElicit: kotlin.String? = builder.slotToElicit
    /**
     * Map of the slots that have been gathered and their values.
     */
    public val slots: Map<String, String>? = builder.slots

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimeservice.model.IntentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IntentSummary(")
        append("checkpointLabel=$checkpointLabel,")
        append("confirmationStatus=$confirmationStatus,")
        append("dialogActionType=$dialogActionType,")
        append("fulfillmentState=$fulfillmentState,")
        append("intentName=$intentName,")
        append("slotToElicit=$slotToElicit,")
        append("slots=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkpointLabel?.hashCode() ?: 0
        result = 31 * result + (confirmationStatus?.hashCode() ?: 0)
        result = 31 * result + (dialogActionType.hashCode())
        result = 31 * result + (fulfillmentState?.hashCode() ?: 0)
        result = 31 * result + (intentName?.hashCode() ?: 0)
        result = 31 * result + (slotToElicit?.hashCode() ?: 0)
        result = 31 * result + (slots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IntentSummary

        if (checkpointLabel != other.checkpointLabel) return false
        if (confirmationStatus != other.confirmationStatus) return false
        if (dialogActionType != other.dialogActionType) return false
        if (fulfillmentState != other.fulfillmentState) return false
        if (intentName != other.intentName) return false
        if (slotToElicit != other.slotToElicit) return false
        if (slots != other.slots) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimeservice.model.IntentSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A user-defined label that identifies a particular intent. You can use this label to return to a previous intent.
         *
         * Use the `checkpointLabelFilter` parameter of the `GetSessionRequest` operation to filter the intents returned by the operation to those with only the specified label.
         */
        public var checkpointLabel: kotlin.String? = null
        /**
         * The status of the intent after the user responds to the confirmation prompt. If the user confirms the intent, Amazon Lex sets this field to `Confirmed`. If the user denies the intent, Amazon Lex sets this value to `Denied`. The possible values are:
         * + `Confirmed` - The user has responded "Yes" to the confirmation prompt, confirming that the intent is complete and that it is ready to be fulfilled.
         * + `Denied` - The user has responded "No" to the confirmation prompt.
         * + `None` - The user has never been prompted for confirmation; or, the user was prompted but did not confirm or deny the prompt.
         */
        public var confirmationStatus: aws.sdk.kotlin.services.lexruntimeservice.model.ConfirmationStatus? = null
        /**
         * The next action that the bot should take in its interaction with the user. The possible values are:
         * + `ConfirmIntent` - The next action is asking the user if the intent is complete and ready to be fulfilled. This is a yes/no question such as "Place the order?"
         * + `Close` - Indicates that the there will not be a response from the user. For example, the statement "Your order has been placed" does not require a response.
         * + `ElicitIntent` - The next action is to determine the intent that the user wants to fulfill.
         * + `ElicitSlot` - The next action is to elicit a slot value from the user.
         */
        public var dialogActionType: aws.sdk.kotlin.services.lexruntimeservice.model.DialogActionType? = null
        /**
         * The fulfillment state of the intent. The possible values are:
         * + `Failed` - The Lambda function associated with the intent failed to fulfill the intent.
         * + `Fulfilled` - The intent has fulfilled by the Lambda function associated with the intent.
         * + `ReadyForFulfillment` - All of the information necessary for the intent is present and the intent ready to be fulfilled by the client application.
         */
        public var fulfillmentState: aws.sdk.kotlin.services.lexruntimeservice.model.FulfillmentState? = null
        /**
         * The name of the intent.
         */
        public var intentName: kotlin.String? = null
        /**
         * The next slot to elicit from the user. If there is not slot to elicit, the field is blank.
         */
        public var slotToElicit: kotlin.String? = null
        /**
         * Map of the slots that have been gathered and their values.
         */
        public var slots: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimeservice.model.IntentSummary) : this() {
            this.checkpointLabel = x.checkpointLabel
            this.confirmationStatus = x.confirmationStatus
            this.dialogActionType = x.dialogActionType
            this.fulfillmentState = x.fulfillmentState
            this.intentName = x.intentName
            this.slotToElicit = x.slotToElicit
            this.slots = x.slots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimeservice.model.IntentSummary = IntentSummary(this)

        internal fun correctErrors(): Builder {
            if (dialogActionType == null) dialogActionType = DialogActionType.SdkUnknown("no value provided")
            return this
        }
    }
}
