// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexruntimeservice.model



/**
 * A context is a variable that contains information about the current state of the conversation between a user and Amazon Lex. Context can be set automatically by Amazon Lex when an intent is fulfilled, or it can be set at runtime using the `PutContent`, `PutText`, or `PutSession` operation.
 */
public class ActiveContext private constructor(builder: Builder) {
    /**
     * The name of the context.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * State variables for the current context. You can use these values as default values for slots in subsequent events.
     */
    public val parameters: Map<String, String> = requireNotNull(builder.parameters) { "A non-null value must be provided for parameters" }
    /**
     * The length of time or number of turns that a context remains active.
     */
    public val timeToLive: aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContextTimeToLive? = builder.timeToLive

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContext = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveContext(")
        append("name=$name,")
        append("parameters=$parameters,")
        append("timeToLive=$timeToLive")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (parameters.hashCode())
        result = 31 * result + (timeToLive?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActiveContext

        if (name != other.name) return false
        if (parameters != other.parameters) return false
        if (timeToLive != other.timeToLive) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContext = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the context.
         */
        public var name: kotlin.String? = null
        /**
         * State variables for the current context. You can use these values as default values for slots in subsequent events.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The length of time or number of turns that a context remains active.
         */
        public var timeToLive: aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContextTimeToLive? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContext) : this() {
            this.name = x.name
            this.parameters = x.parameters
            this.timeToLive = x.timeToLive
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContext = ActiveContext(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContextTimeToLive] inside the given [block]
         */
        public fun timeToLive(block: aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContextTimeToLive.Builder.() -> kotlin.Unit) {
            this.timeToLive = aws.sdk.kotlin.services.lexruntimeservice.model.ActiveContextTimeToLive.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (parameters == null) parameters = emptyMap()
            return this
        }
    }
}
