// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.waiters

import aws.sdk.kotlin.services.lexmodelsv2.LexModelsV2Client
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotAliasRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotAliasResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotVersionRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotVersionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeExportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeExportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeImportRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeImportResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a bot is available
 */
suspend fun LexModelsV2Client.waitUntilBotAvailable(request: DescribeBotRequest): Outcome<DescribeBotResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBotRequest, DescribeBotResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botStatus = it?.botStatus
            botStatus?.toString() == "Available"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botStatus = it?.botStatus
            botStatus?.toString() == "Deleting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botStatus = it?.botStatus
            botStatus?.toString() == "Failed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botStatus = it?.botStatus
            botStatus?.toString() == "Inactive"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBot(request) }
}

/**
 * Wait until a bot is available
 */
suspend fun LexModelsV2Client.waitUntilBotAvailable(block: DescribeBotRequest.Builder.() -> Unit): Outcome<DescribeBotResponse> =
    waitUntilBotAvailable(DescribeBotRequest.Builder().apply(block).build())

/**
 * Wait until a bot alias is available
 */
suspend fun LexModelsV2Client.waitUntilBotAliasAvailable(request: DescribeBotAliasRequest): Outcome<DescribeBotAliasResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBotAliasRequest, DescribeBotAliasResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botAliasStatus = it?.botAliasStatus
            botAliasStatus?.toString() == "Available"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botAliasStatus = it?.botAliasStatus
            botAliasStatus?.toString() == "Failed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botAliasStatus = it?.botAliasStatus
            botAliasStatus?.toString() == "Deleting"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBotAlias(request) }
}

/**
 * Wait until a bot alias is available
 */
suspend fun LexModelsV2Client.waitUntilBotAliasAvailable(block: DescribeBotAliasRequest.Builder.() -> Unit): Outcome<DescribeBotAliasResponse> =
    waitUntilBotAliasAvailable(DescribeBotAliasRequest.Builder().apply(block).build())

/**
 * Wait until a bot locale is built
 */
suspend fun LexModelsV2Client.waitUntilBotLocaleBuilt(request: DescribeBotLocaleRequest): Outcome<DescribeBotLocaleResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBotLocaleRequest, DescribeBotLocaleResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Built"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Deleting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Failed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "NotBuilt"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBotLocale(request) }
}

/**
 * Wait until a bot locale is built
 */
suspend fun LexModelsV2Client.waitUntilBotLocaleBuilt(block: DescribeBotLocaleRequest.Builder.() -> Unit): Outcome<DescribeBotLocaleResponse> =
    waitUntilBotLocaleBuilt(DescribeBotLocaleRequest.Builder().apply(block).build())

/**
 * Wait unit a bot locale is created
 */
suspend fun LexModelsV2Client.waitUntilBotLocaleCreated(request: DescribeBotLocaleRequest): Outcome<DescribeBotLocaleResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBotLocaleRequest, DescribeBotLocaleResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Built"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "ReadyExpressTesting"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "NotBuilt"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Deleting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBotLocale(request) }
}

/**
 * Wait unit a bot locale is created
 */
suspend fun LexModelsV2Client.waitUntilBotLocaleCreated(block: DescribeBotLocaleRequest.Builder.() -> Unit): Outcome<DescribeBotLocaleResponse> =
    waitUntilBotLocaleCreated(DescribeBotLocaleRequest.Builder().apply(block).build())

/**
 * Wait until a bot locale build is ready for express testing
 */
suspend fun LexModelsV2Client.waitUntilBotLocaleExpressTestingAvailable(request: DescribeBotLocaleRequest): Outcome<DescribeBotLocaleResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBotLocaleRequest, DescribeBotLocaleResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Built"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "ReadyExpressTesting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Deleting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "Failed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botLocaleStatus = it?.botLocaleStatus
            botLocaleStatus?.toString() == "NotBuilt"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBotLocale(request) }
}

/**
 * Wait until a bot locale build is ready for express testing
 */
suspend fun LexModelsV2Client.waitUntilBotLocaleExpressTestingAvailable(block: DescribeBotLocaleRequest.Builder.() -> Unit): Outcome<DescribeBotLocaleResponse> =
    waitUntilBotLocaleExpressTestingAvailable(DescribeBotLocaleRequest.Builder().apply(block).build())

/**
 * Wait until a bot version is available
 */
suspend fun LexModelsV2Client.waitUntilBotVersionAvailable(request: DescribeBotVersionRequest): Outcome<DescribeBotVersionResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeBotVersionRequest, DescribeBotVersionResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val botStatus = it?.botStatus
            botStatus?.toString() == "Available"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botStatus = it?.botStatus
            botStatus?.toString() == "Deleting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val botStatus = it?.botStatus
            botStatus?.toString() == "Failed"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeBotVersion(request) }
}

/**
 * Wait until a bot version is available
 */
suspend fun LexModelsV2Client.waitUntilBotVersionAvailable(block: DescribeBotVersionRequest.Builder.() -> Unit): Outcome<DescribeBotVersionResponse> =
    waitUntilBotVersionAvailable(DescribeBotVersionRequest.Builder().apply(block).build())

/**
 * Wait until a bot has been exported
 */
suspend fun LexModelsV2Client.waitUntilBotExportCompleted(request: DescribeExportRequest): Outcome<DescribeExportResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeExportRequest, DescribeExportResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val exportStatus = it?.exportStatus
            exportStatus?.toString() == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val exportStatus = it?.exportStatus
            exportStatus?.toString() == "Deleting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val exportStatus = it?.exportStatus
            exportStatus?.toString() == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeExport(request) }
}

/**
 * Wait until a bot has been exported
 */
suspend fun LexModelsV2Client.waitUntilBotExportCompleted(block: DescribeExportRequest.Builder.() -> Unit): Outcome<DescribeExportResponse> =
    waitUntilBotExportCompleted(DescribeExportRequest.Builder().apply(block).build())

/**
 * Wait until a bot has been imported
 */
suspend fun LexModelsV2Client.waitUntilBotImportCompleted(request: DescribeImportRequest): Outcome<DescribeImportResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 10_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeImportRequest, DescribeImportResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val importStatus = it?.importStatus
            importStatus?.toString() == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val importStatus = it?.importStatus
            importStatus?.toString() == "Deleting"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val importStatus = it?.importStatus
            importStatus?.toString() == "Failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeImport(request) }
}

/**
 * Wait until a bot has been imported
 */
suspend fun LexModelsV2Client.waitUntilBotImportCompleted(block: DescribeImportRequest.Builder.() -> Unit): Outcome<DescribeImportResponse> =
    waitUntilBotImportCompleted(DescribeImportRequest.Builder().apply(block).build())
