// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeValue
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotTypeRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSlotTypeOperationSerializer: HttpSerialize<UpdateSlotTypeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateSlotTypeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botversions",
                "${input.botVersion}".encodeLabel(),
                "botlocales",
                "${input.localeId}".encodeLabel(),
                "slottypes",
                "${input.slotTypeId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateSlotTypeOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSlotTypeOperationBody(context: ExecutionContext, input: UpdateSlotTypeRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXTERNALSOURCESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("externalSourceSetting"))
    val PARENTSLOTTYPESIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentSlotTypeSignature"))
    val SLOTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeName"))
    val SLOTTYPEVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("slotTypeValues"))
    val VALUESELECTIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("valueSelectionSetting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(EXTERNALSOURCESETTING_DESCRIPTOR)
        field(PARENTSLOTTYPESIGNATURE_DESCRIPTOR)
        field(SLOTTYPENAME_DESCRIPTOR)
        field(SLOTTYPEVALUES_DESCRIPTOR)
        field(VALUESELECTIONSETTING_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.externalSourceSetting?.let { field(EXTERNALSOURCESETTING_DESCRIPTOR, it, ::serializeExternalSourceSettingDocument) }
        input.parentSlotTypeSignature?.let { field(PARENTSLOTTYPESIGNATURE_DESCRIPTOR, it) }
        input.slotTypeName?.let { field(SLOTTYPENAME_DESCRIPTOR, it) }
        if (input.slotTypeValues != null) {
            listField(SLOTTYPEVALUES_DESCRIPTOR) {
                for (el0 in input.slotTypeValues) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSlotTypeValueDocument))
                }
            }
        }
        input.valueSelectionSetting?.let { field(VALUESELECTIONSETTING_DESCRIPTOR, it, ::serializeSlotValueSelectionSettingDocument) }
    }
    return serializer.toByteArray()
}
