// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.ExternalSourceSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotTypeValue
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueSelectionSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotTypeResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateSlotTypeOperationDeserializer: HttpDeserialize<UpdateSlotTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSlotTypeResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSlotTypeError(context, response)
        }
        val builder = UpdateSlotTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSlotTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateSlotTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSlotTypeOperationBody(builder: UpdateSlotTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXTERNALSOURCESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("externalSourceSetting"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val PARENTSLOTTYPESIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentSlotTypeSignature"))
    val SLOTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeId"))
    val SLOTTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeName"))
    val SLOTTYPEVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("slotTypeValues"))
    val VALUESELECTIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("valueSelectionSetting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXTERNALSOURCESETTING_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(PARENTSLOTTYPESIGNATURE_DESCRIPTOR)
        field(SLOTTYPEID_DESCRIPTOR)
        field(SLOTTYPENAME_DESCRIPTOR)
        field(SLOTTYPEVALUES_DESCRIPTOR)
        field(VALUESELECTIONSETTING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EXTERNALSOURCESETTING_DESCRIPTOR.index -> builder.externalSourceSetting = deserializeExternalSourceSettingDocument(deserializer)
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                PARENTSLOTTYPESIGNATURE_DESCRIPTOR.index -> builder.parentSlotTypeSignature = deserializeString()
                SLOTTYPEID_DESCRIPTOR.index -> builder.slotTypeId = deserializeString()
                SLOTTYPENAME_DESCRIPTOR.index -> builder.slotTypeName = deserializeString()
                SLOTTYPEVALUES_DESCRIPTOR.index -> builder.slotTypeValues =
                    deserializer.deserializeList(SLOTTYPEVALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<SlotTypeValue>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSlotTypeValueDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VALUESELECTIONSETTING_DESCRIPTOR.index -> builder.valueSelectionSetting = deserializeSlotValueSelectionSettingDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
