// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSlotOperationSerializer: HttpSerialize<UpdateSlotRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateSlotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botversions",
                "${input.botVersion}".encodeLabel(),
                "botlocales",
                "${input.localeId}".encodeLabel(),
                "intents",
                "${input.intentId}".encodeLabel(),
                "slots",
                "${input.slotId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateSlotOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSlotOperationBody(context: ExecutionContext, input: UpdateSlotRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val MULTIPLEVALUESSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("multipleValuesSetting"))
    val OBFUSCATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("obfuscationSetting"))
    val SLOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotName"))
    val SLOTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("slotTypeId"))
    val VALUEELICITATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("valueElicitationSetting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(MULTIPLEVALUESSETTING_DESCRIPTOR)
        field(OBFUSCATIONSETTING_DESCRIPTOR)
        field(SLOTNAME_DESCRIPTOR)
        field(SLOTTYPEID_DESCRIPTOR)
        field(VALUEELICITATIONSETTING_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.multipleValuesSetting?.let { field(MULTIPLEVALUESSETTING_DESCRIPTOR, it, ::serializeMultipleValuesSettingDocument) }
        input.obfuscationSetting?.let { field(OBFUSCATIONSETTING_DESCRIPTOR, it, ::serializeObfuscationSettingDocument) }
        input.slotName?.let { field(SLOTNAME_DESCRIPTOR, it) }
        input.slotTypeId?.let { field(SLOTTYPEID_DESCRIPTOR, it) }
        input.valueElicitationSetting?.let { field(VALUEELICITATIONSETTING_DESCRIPTOR, it, ::serializeSlotValueElicitationSettingDocument) }
    }
    return serializer.toByteArray()
}
