// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.InputContext
import aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.OutputContext
import aws.sdk.kotlin.services.lexmodelsv2.model.SampleUtterance
import aws.sdk.kotlin.services.lexmodelsv2.model.SlotPriority
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateIntentResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateIntentOperationDeserializer: HttpDeserialize<UpdateIntentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateIntentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateIntentError(context, response)
        }
        val builder = UpdateIntentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateIntentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateIntentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateIntentOperationBody(builder: UpdateIntentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DIALOGCODEHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dialogCodeHook"))
    val FULFILLMENTCODEHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("fulfillmentCodeHook"))
    val INPUTCONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputContexts"))
    val INTENTCLOSINGSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("intentClosingSetting"))
    val INTENTCONFIRMATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("intentConfirmationSetting"))
    val INTENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("intentId"))
    val INTENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("intentName"))
    val KENDRACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kendraConfiguration"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val OUTPUTCONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputContexts"))
    val PARENTINTENTSIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentIntentSignature"))
    val SAMPLEUTTERANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sampleUtterances"))
    val SLOTPRIORITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("slotPriorities"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DIALOGCODEHOOK_DESCRIPTOR)
        field(FULFILLMENTCODEHOOK_DESCRIPTOR)
        field(INPUTCONTEXTS_DESCRIPTOR)
        field(INTENTCLOSINGSETTING_DESCRIPTOR)
        field(INTENTCONFIRMATIONSETTING_DESCRIPTOR)
        field(INTENTID_DESCRIPTOR)
        field(INTENTNAME_DESCRIPTOR)
        field(KENDRACONFIGURATION_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(OUTPUTCONTEXTS_DESCRIPTOR)
        field(PARENTINTENTSIGNATURE_DESCRIPTOR)
        field(SAMPLEUTTERANCES_DESCRIPTOR)
        field(SLOTPRIORITIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DIALOGCODEHOOK_DESCRIPTOR.index -> builder.dialogCodeHook = deserializeDialogCodeHookSettingsDocument(deserializer)
                FULFILLMENTCODEHOOK_DESCRIPTOR.index -> builder.fulfillmentCodeHook = deserializeFulfillmentCodeHookSettingsDocument(deserializer)
                INPUTCONTEXTS_DESCRIPTOR.index -> builder.inputContexts =
                    deserializer.deserializeList(INPUTCONTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<InputContext>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInputContextDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INTENTCLOSINGSETTING_DESCRIPTOR.index -> builder.intentClosingSetting = deserializeIntentClosingSettingDocument(deserializer)
                INTENTCONFIRMATIONSETTING_DESCRIPTOR.index -> builder.intentConfirmationSetting = deserializeIntentConfirmationSettingDocument(deserializer)
                INTENTID_DESCRIPTOR.index -> builder.intentId = deserializeString()
                INTENTNAME_DESCRIPTOR.index -> builder.intentName = deserializeString()
                KENDRACONFIGURATION_DESCRIPTOR.index -> builder.kendraConfiguration = deserializeKendraConfigurationDocument(deserializer)
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                OUTPUTCONTEXTS_DESCRIPTOR.index -> builder.outputContexts =
                    deserializer.deserializeList(OUTPUTCONTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<OutputContext>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOutputContextDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PARENTINTENTSIGNATURE_DESCRIPTOR.index -> builder.parentIntentSignature = deserializeString()
                SAMPLEUTTERANCES_DESCRIPTOR.index -> builder.sampleUtterances =
                    deserializer.deserializeList(SAMPLEUTTERANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<SampleUtterance>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSampleUtteranceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SLOTPRIORITIES_DESCRIPTOR.index -> builder.slotPriorities =
                    deserializer.deserializeList(SLOTPRIORITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<SlotPriority>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSlotPriorityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
