// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.services.lexmodelsv2.model.BotAliasLocaleSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.UpdateBotAliasRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBotAliasOperationSerializer: HttpSerialize<UpdateBotAliasRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateBotAliasRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botaliases",
                "${input.botAliasId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateBotAliasOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateBotAliasOperationBody(context: ExecutionContext, input: UpdateBotAliasRequest): ByteArray {
    val serializer = JsonSerializer()
    val BOTALIASLOCALESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("botAliasLocaleSettings"))
    val BOTALIASNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasName"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CONVERSATIONLOGSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("conversationLogSettings"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val SENTIMENTANALYSISSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sentimentAnalysisSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTALIASLOCALESETTINGS_DESCRIPTOR)
        field(BOTALIASNAME_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CONVERSATIONLOGSETTINGS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(SENTIMENTANALYSISSETTINGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.botAliasLocaleSettings != null) {
            mapField(BOTALIASLOCALESETTINGS_DESCRIPTOR) {
                input.botAliasLocaleSettings.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeBotAliasLocaleSettingsDocument)) }
            }
        }
        input.botAliasName?.let { field(BOTALIASNAME_DESCRIPTOR, it) }
        input.botVersion?.let { field(BOTVERSION_DESCRIPTOR, it) }
        input.conversationLogSettings?.let { field(CONVERSATIONLOGSETTINGS_DESCRIPTOR, it, ::serializeConversationLogSettingsDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.sentimentAnalysisSettings?.let { field(SENTIMENTANALYSISSETTINGS_DESCRIPTOR, it, ::serializeSentimentAnalysisSettingsDocument) }
    }
    return serializer.toByteArray()
}
