// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.BotRecommendationStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.EncryptionSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.StartBotRecommendationResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.TranscriptSourceSetting
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class StartBotRecommendationOperationDeserializer: HttpDeserialize<StartBotRecommendationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartBotRecommendationResponse {
        if (!response.status.isSuccess()) {
            throwStartBotRecommendationError(context, response)
        }
        val builder = StartBotRecommendationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartBotRecommendationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartBotRecommendationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartBotRecommendationOperationBody(builder: StartBotRecommendationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTRECOMMENDATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botRecommendationId"))
    val BOTRECOMMENDATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botRecommendationStatus"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val ENCRYPTIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("encryptionSetting"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val TRANSCRIPTSOURCESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("transcriptSourceSetting"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTRECOMMENDATIONID_DESCRIPTOR)
        field(BOTRECOMMENDATIONSTATUS_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(ENCRYPTIONSETTING_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(TRANSCRIPTSOURCESETTING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTRECOMMENDATIONID_DESCRIPTOR.index -> builder.botRecommendationId = deserializeString()
                BOTRECOMMENDATIONSTATUS_DESCRIPTOR.index -> builder.botRecommendationStatus = deserializeString().let { BotRecommendationStatus.fromValue(it) }
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENCRYPTIONSETTING_DESCRIPTOR.index -> builder.encryptionSetting = deserializeEncryptionSettingDocument(deserializer)
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                TRANSCRIPTSOURCESETTING_DESCRIPTOR.index -> builder.transcriptSourceSetting = deserializeTranscriptSourceSettingDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
