// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.services.lexmodelsv2.model.AssociatedTranscriptFilter
import aws.sdk.kotlin.services.lexmodelsv2.model.SearchAssociatedTranscriptsRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.SearchOrder
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchAssociatedTranscriptsOperationSerializer: HttpSerialize<SearchAssociatedTranscriptsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SearchAssociatedTranscriptsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botversions",
                "${input.botVersion}".encodeLabel(),
                "botlocales",
                "${input.localeId}".encodeLabel(),
                "botrecommendations",
                "${input.botRecommendationId}".encodeLabel(),
                "associatedtranscripts",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeSearchAssociatedTranscriptsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchAssociatedTranscriptsOperationBody(context: ExecutionContext, input: SearchAssociatedTranscriptsRequest): ByteArray {
    val serializer = JsonSerializer()
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTINDEX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("nextIndex"))
    val SEARCHORDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("searchOrder"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTINDEX_DESCRIPTOR)
        field(SEARCHORDER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAssociatedTranscriptFilterDocument))
                }
            }
        }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextIndex?.let { field(NEXTINDEX_DESCRIPTOR, it) }
        input.searchOrder?.let { field(SEARCHORDER_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
