// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.AggregatedUtterancesSummary
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.ListAggregatedUtterancesResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.UtteranceAggregationDuration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class ListAggregatedUtterancesOperationDeserializer: HttpDeserialize<ListAggregatedUtterancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAggregatedUtterancesResponse {
        if (!response.status.isSuccess()) {
            throwListAggregatedUtterancesError(context, response)
        }
        val builder = ListAggregatedUtterancesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAggregatedUtterancesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAggregatedUtterancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAggregatedUtterancesOperationBody(builder: ListAggregatedUtterancesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGGREGATEDUTTERANCESSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("aggregatedUtterancesSummaries"))
    val AGGREGATIONDURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("aggregationDuration"))
    val AGGREGATIONLASTREFRESHEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("aggregationLastRefreshedDateTime"))
    val AGGREGATIONWINDOWENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("aggregationWindowEndTime"))
    val AGGREGATIONWINDOWSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("aggregationWindowStartTime"))
    val BOTALIASID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasId"))
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGGREGATEDUTTERANCESSUMMARIES_DESCRIPTOR)
        field(AGGREGATIONDURATION_DESCRIPTOR)
        field(AGGREGATIONLASTREFRESHEDDATETIME_DESCRIPTOR)
        field(AGGREGATIONWINDOWENDTIME_DESCRIPTOR)
        field(AGGREGATIONWINDOWSTARTTIME_DESCRIPTOR)
        field(BOTALIASID_DESCRIPTOR)
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGGREGATEDUTTERANCESSUMMARIES_DESCRIPTOR.index -> builder.aggregatedUtterancesSummaries =
                    deserializer.deserializeList(AGGREGATEDUTTERANCESSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AggregatedUtterancesSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAggregatedUtterancesSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AGGREGATIONDURATION_DESCRIPTOR.index -> builder.aggregationDuration = deserializeUtteranceAggregationDurationDocument(deserializer)
                AGGREGATIONLASTREFRESHEDDATETIME_DESCRIPTOR.index -> builder.aggregationLastRefreshedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                AGGREGATIONWINDOWENDTIME_DESCRIPTOR.index -> builder.aggregationWindowEndTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                AGGREGATIONWINDOWSTARTTIME_DESCRIPTOR.index -> builder.aggregationWindowStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                BOTALIASID_DESCRIPTOR.index -> builder.botAliasId = deserializeString()
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
