// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeImportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ImportResourceSpecification
import aws.sdk.kotlin.services.lexmodelsv2.model.ImportStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.MergeStrategy
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeImportOperationDeserializer: HttpDeserialize<DescribeImportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeImportResponse {
        if (!response.status.isSuccess()) {
            throwDescribeImportError(context, response)
        }
        val builder = DescribeImportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeImportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeImportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeImportOperationBody(builder: DescribeImportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val IMPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importId"))
    val IMPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importStatus"))
    val IMPORTEDRESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedResourceId"))
    val IMPORTEDRESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importedResourceName"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val MERGESTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mergeStrategy"))
    val RESOURCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceSpecification"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATETIME_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(IMPORTID_DESCRIPTOR)
        field(IMPORTSTATUS_DESCRIPTOR)
        field(IMPORTEDRESOURCEID_DESCRIPTOR)
        field(IMPORTEDRESOURCENAME_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(MERGESTRATEGY_DESCRIPTOR)
        field(RESOURCESPECIFICATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMPORTID_DESCRIPTOR.index -> builder.importId = deserializeString()
                IMPORTSTATUS_DESCRIPTOR.index -> builder.importStatus = deserializeString().let { ImportStatus.fromValue(it) }
                IMPORTEDRESOURCEID_DESCRIPTOR.index -> builder.importedResourceId = deserializeString()
                IMPORTEDRESOURCENAME_DESCRIPTOR.index -> builder.importedResourceName = deserializeString()
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MERGESTRATEGY_DESCRIPTOR.index -> builder.mergeStrategy = deserializeString().let { MergeStrategy.fromValue(it) }
                RESOURCESPECIFICATION_DESCRIPTOR.index -> builder.resourceSpecification = deserializeImportResourceSpecificationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
