// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeExportResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.ExportResourceSpecification
import aws.sdk.kotlin.services.lexmodelsv2.model.ExportStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.ImportExportFileFormat
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeExportOperationDeserializer: HttpDeserialize<DescribeExportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeExportResponse {
        if (!response.status.isSuccess()) {
            throwDescribeExportError(context, response)
        }
        val builder = DescribeExportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeExportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeExportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExportOperationBody(builder: DescribeExportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DOWNLOADURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("downloadUrl"))
    val EXPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("exportId"))
    val EXPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("exportStatus"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val FILEFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fileFormat"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val RESOURCESPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceSpecification"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DOWNLOADURL_DESCRIPTOR)
        field(EXPORTID_DESCRIPTOR)
        field(EXPORTSTATUS_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(FILEFORMAT_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(RESOURCESPECIFICATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DOWNLOADURL_DESCRIPTOR.index -> builder.downloadUrl = deserializeString()
                EXPORTID_DESCRIPTOR.index -> builder.exportId = deserializeString()
                EXPORTSTATUS_DESCRIPTOR.index -> builder.exportStatus = deserializeString().let { ExportStatus.fromValue(it) }
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FILEFORMAT_DESCRIPTOR.index -> builder.fileFormat = deserializeString().let { ImportExportFileFormat.fromValue(it) }
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                RESOURCESPECIFICATION_DESCRIPTOR.index -> builder.resourceSpecification = deserializeExportResourceSpecificationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
