// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.BotStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.DataPrivacy
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotVersionResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeBotVersionOperationDeserializer: HttpDeserialize<DescribeBotVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeBotVersionResponse {
        if (!response.status.isSuccess()) {
            throwDescribeBotVersionError(context, response)
        }
        val builder = DescribeBotVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeBotVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeBotVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBotVersionOperationBody(builder: DescribeBotVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botName"))
    val BOTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botStatus"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DATAPRIVACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dataPrivacy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val IDLESESSIONTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("idleSessionTTLInSeconds"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTNAME_DESCRIPTOR)
        field(BOTSTATUS_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DATAPRIVACY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(IDLESESSIONTTLINSECONDS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTNAME_DESCRIPTOR.index -> builder.botName = deserializeString()
                BOTSTATUS_DESCRIPTOR.index -> builder.botStatus = deserializeString().let { BotStatus.fromValue(it) }
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATAPRIVACY_DESCRIPTOR.index -> builder.dataPrivacy = deserializeDataPrivacyDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IDLESESSIONTTLINSECONDS_DESCRIPTOR.index -> builder.idleSessionTtlInSeconds = deserializeInt()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
