// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleHistoryEvent
import aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.DescribeBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeBotLocaleOperationDeserializer: HttpDeserialize<DescribeBotLocaleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeBotLocaleResponse {
        if (!response.status.isSuccess()) {
            throwDescribeBotLocaleError(context, response)
        }
        val builder = DescribeBotLocaleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeBotLocaleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeBotLocaleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBotLocaleOperationBody(builder: DescribeBotLocaleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTLOCALEHISTORYEVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("botLocaleHistoryEvents"))
    val BOTLOCALESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botLocaleStatus"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failureReasons"))
    val INTENTSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("intentsCount"))
    val LASTBUILDSUBMITTEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastBuildSubmittedDateTime"))
    val LASTUPDATEDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDateTime"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val LOCALENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeName"))
    val NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("nluIntentConfidenceThreshold"))
    val RECOMMENDEDACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("recommendedActions"))
    val SLOTTYPESCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("slotTypesCount"))
    val VOICESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("voiceSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTLOCALEHISTORYEVENTS_DESCRIPTOR)
        field(BOTLOCALESTATUS_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FAILUREREASONS_DESCRIPTOR)
        field(INTENTSCOUNT_DESCRIPTOR)
        field(LASTBUILDSUBMITTEDDATETIME_DESCRIPTOR)
        field(LASTUPDATEDDATETIME_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(LOCALENAME_DESCRIPTOR)
        field(NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR)
        field(RECOMMENDEDACTIONS_DESCRIPTOR)
        field(SLOTTYPESCOUNT_DESCRIPTOR)
        field(VOICESETTINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTLOCALEHISTORYEVENTS_DESCRIPTOR.index -> builder.botLocaleHistoryEvents =
                    deserializer.deserializeList(BOTLOCALEHISTORYEVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<BotLocaleHistoryEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBotLocaleHistoryEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BOTLOCALESTATUS_DESCRIPTOR.index -> builder.botLocaleStatus = deserializeString().let { BotLocaleStatus.fromValue(it) }
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FAILUREREASONS_DESCRIPTOR.index -> builder.failureReasons =
                    deserializer.deserializeList(FAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INTENTSCOUNT_DESCRIPTOR.index -> builder.intentsCount = deserializeInt()
                LASTBUILDSUBMITTEDDATETIME_DESCRIPTOR.index -> builder.lastBuildSubmittedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTUPDATEDDATETIME_DESCRIPTOR.index -> builder.lastUpdatedDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                LOCALENAME_DESCRIPTOR.index -> builder.localeName = deserializeString()
                NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR.index -> builder.nluIntentConfidenceThreshold = deserializeDouble()
                RECOMMENDEDACTIONS_DESCRIPTOR.index -> builder.recommendedActions =
                    deserializer.deserializeList(RECOMMENDEDACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SLOTTYPESCOUNT_DESCRIPTOR.index -> builder.slotTypesCount = deserializeInt()
                VOICESETTINGS_DESCRIPTOR.index -> builder.voiceSettings = deserializeVoiceSettingsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
