// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.DeleteSlotResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteSlotOperationDeserializer: HttpDeserialize<DeleteSlotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteSlotResponse {
        if (!response.status.isSuccess()) {
            throwDeleteSlotError(context, response)
        }
        val builder = DeleteSlotResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteSlotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
