// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateResourcePolicyStatementOperationDeserializer: HttpDeserialize<CreateResourcePolicyStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateResourcePolicyStatementResponse {
        if (!response.status.isSuccess()) {
            throwCreateResourcePolicyStatementError(context, response)
        }
        val builder = CreateResourcePolicyStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateResourcePolicyStatementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateResourcePolicyStatementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateResourcePolicyStatementOperationBody(builder: CreateResourcePolicyStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceArn"))
    val REVISIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("revisionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOURCEARN_DESCRIPTOR)
        field(REVISIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                REVISIONID_DESCRIPTOR.index -> builder.revisionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
