// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.services.lexmodelsv2.model.CreateIntentRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.DialogCodeHookSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.FulfillmentCodeHookSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.InputContext
import aws.sdk.kotlin.services.lexmodelsv2.model.IntentClosingSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.IntentConfirmationSetting
import aws.sdk.kotlin.services.lexmodelsv2.model.KendraConfiguration
import aws.sdk.kotlin.services.lexmodelsv2.model.OutputContext
import aws.sdk.kotlin.services.lexmodelsv2.model.SampleUtterance
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateIntentOperationSerializer: HttpSerialize<CreateIntentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateIntentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botversions",
                "${input.botVersion}".encodeLabel(),
                "botlocales",
                "${input.localeId}".encodeLabel(),
                "intents",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateIntentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateIntentOperationBody(context: ExecutionContext, input: CreateIntentRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DIALOGCODEHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("dialogCodeHook"))
    val FULFILLMENTCODEHOOK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("fulfillmentCodeHook"))
    val INPUTCONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("inputContexts"))
    val INTENTCLOSINGSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("intentClosingSetting"))
    val INTENTCONFIRMATIONSETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("intentConfirmationSetting"))
    val INTENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("intentName"))
    val KENDRACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kendraConfiguration"))
    val OUTPUTCONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputContexts"))
    val PARENTINTENTSIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentIntentSignature"))
    val SAMPLEUTTERANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sampleUtterances"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(DIALOGCODEHOOK_DESCRIPTOR)
        field(FULFILLMENTCODEHOOK_DESCRIPTOR)
        field(INPUTCONTEXTS_DESCRIPTOR)
        field(INTENTCLOSINGSETTING_DESCRIPTOR)
        field(INTENTCONFIRMATIONSETTING_DESCRIPTOR)
        field(INTENTNAME_DESCRIPTOR)
        field(KENDRACONFIGURATION_DESCRIPTOR)
        field(OUTPUTCONTEXTS_DESCRIPTOR)
        field(PARENTINTENTSIGNATURE_DESCRIPTOR)
        field(SAMPLEUTTERANCES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.dialogCodeHook?.let { field(DIALOGCODEHOOK_DESCRIPTOR, it, ::serializeDialogCodeHookSettingsDocument) }
        input.fulfillmentCodeHook?.let { field(FULFILLMENTCODEHOOK_DESCRIPTOR, it, ::serializeFulfillmentCodeHookSettingsDocument) }
        if (input.inputContexts != null) {
            listField(INPUTCONTEXTS_DESCRIPTOR) {
                for (el0 in input.inputContexts) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInputContextDocument))
                }
            }
        }
        input.intentClosingSetting?.let { field(INTENTCLOSINGSETTING_DESCRIPTOR, it, ::serializeIntentClosingSettingDocument) }
        input.intentConfirmationSetting?.let { field(INTENTCONFIRMATIONSETTING_DESCRIPTOR, it, ::serializeIntentConfirmationSettingDocument) }
        input.intentName?.let { field(INTENTNAME_DESCRIPTOR, it) }
        input.kendraConfiguration?.let { field(KENDRACONFIGURATION_DESCRIPTOR, it, ::serializeKendraConfigurationDocument) }
        if (input.outputContexts != null) {
            listField(OUTPUTCONTEXTS_DESCRIPTOR) {
                for (el0 in input.outputContexts) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeOutputContextDocument))
                }
            }
        }
        input.parentIntentSignature?.let { field(PARENTINTENTSIGNATURE_DESCRIPTOR, it) }
        if (input.sampleUtterances != null) {
            listField(SAMPLEUTTERANCES_DESCRIPTOR) {
                for (el0 in input.sampleUtterances) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSampleUtteranceDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
