// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleRequest
import aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBotLocaleOperationSerializer: HttpSerialize<CreateBotLocaleRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateBotLocaleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "bots",
                "${input.botId}".encodeLabel(),
                "botversions",
                "${input.botVersion}".encodeLabel(),
                "botlocales",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateBotLocaleOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateBotLocaleOperationBody(context: ExecutionContext, input: CreateBotLocaleRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("nluIntentConfidenceThreshold"))
    val VOICESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("voiceSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR)
        field(VOICESETTINGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.localeId?.let { field(LOCALEID_DESCRIPTOR, it) }
        input.nluIntentConfidenceThreshold?.let { field(NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR, it) }
        input.voiceSettings?.let { field(VOICESETTINGS_DESCRIPTOR, it, ::serializeVoiceSettingsDocument) }
    }
    return serializer.toByteArray()
}
