// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.BotLocaleStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotLocaleResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.VoiceSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateBotLocaleOperationDeserializer: HttpDeserialize<CreateBotLocaleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateBotLocaleResponse {
        if (!response.status.isSuccess()) {
            throwCreateBotLocaleError(context, response)
        }
        val builder = CreateBotLocaleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateBotLocaleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateBotLocaleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateBotLocaleOperationBody(builder: CreateBotLocaleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTLOCALESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botLocaleStatus"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LOCALEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeId"))
    val LOCALENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("localeName"))
    val NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("nluIntentConfidenceThreshold"))
    val VOICESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("voiceSettings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTID_DESCRIPTOR)
        field(BOTLOCALESTATUS_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LOCALEID_DESCRIPTOR)
        field(LOCALENAME_DESCRIPTOR)
        field(NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR)
        field(VOICESETTINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTLOCALESTATUS_DESCRIPTOR.index -> builder.botLocaleStatus = deserializeString().let { BotLocaleStatus.fromValue(it) }
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LOCALEID_DESCRIPTOR.index -> builder.localeId = deserializeString()
                LOCALENAME_DESCRIPTOR.index -> builder.localeName = deserializeString()
                NLUINTENTCONFIDENCETHRESHOLD_DESCRIPTOR.index -> builder.nluIntentConfidenceThreshold = deserializeDouble()
                VOICESETTINGS_DESCRIPTOR.index -> builder.voiceSettings = deserializeVoiceSettingsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
