// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lexmodelsv2.model.BotAliasLocaleSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.BotAliasStatus
import aws.sdk.kotlin.services.lexmodelsv2.model.ConversationLogSettings
import aws.sdk.kotlin.services.lexmodelsv2.model.CreateBotAliasResponse
import aws.sdk.kotlin.services.lexmodelsv2.model.LexModelsV2Exception
import aws.sdk.kotlin.services.lexmodelsv2.model.SentimentAnalysisSettings
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateBotAliasOperationDeserializer: HttpDeserialize<CreateBotAliasResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateBotAliasResponse {
        if (!response.status.isSuccess()) {
            throwCreateBotAliasError(context, response)
        }
        val builder = CreateBotAliasResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateBotAliasOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateBotAliasError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LexModelsV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailedException" -> PreconditionFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LexModelsV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateBotAliasOperationBody(builder: CreateBotAliasResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOTALIASID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasId"))
    val BOTALIASLOCALESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("botAliasLocaleSettings"))
    val BOTALIASNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasName"))
    val BOTALIASSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botAliasStatus"))
    val BOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botId"))
    val BOTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("botVersion"))
    val CONVERSATIONLOGSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("conversationLogSettings"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val SENTIMENTANALYSISSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sentimentAnalysisSettings"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOTALIASID_DESCRIPTOR)
        field(BOTALIASLOCALESETTINGS_DESCRIPTOR)
        field(BOTALIASNAME_DESCRIPTOR)
        field(BOTALIASSTATUS_DESCRIPTOR)
        field(BOTID_DESCRIPTOR)
        field(BOTVERSION_DESCRIPTOR)
        field(CONVERSATIONLOGSETTINGS_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(SENTIMENTANALYSISSETTINGS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOTALIASID_DESCRIPTOR.index -> builder.botAliasId = deserializeString()
                BOTALIASLOCALESETTINGS_DESCRIPTOR.index -> builder.botAliasLocaleSettings =
                    deserializer.deserializeMap(BOTALIASLOCALESETTINGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, BotAliasLocaleSettings>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBotAliasLocaleSettingsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                BOTALIASNAME_DESCRIPTOR.index -> builder.botAliasName = deserializeString()
                BOTALIASSTATUS_DESCRIPTOR.index -> builder.botAliasStatus = deserializeString().let { BotAliasStatus.fromValue(it) }
                BOTID_DESCRIPTOR.index -> builder.botId = deserializeString()
                BOTVERSION_DESCRIPTOR.index -> builder.botVersion = deserializeString()
                CONVERSATIONLOGSETTINGS_DESCRIPTOR.index -> builder.conversationLogSettings = deserializeConversationLogSettingsDocument(deserializer)
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                SENTIMENTANALYSISSETTINGS_DESCRIPTOR.index -> builder.sentimentAnalysisSettings = deserializeSentimentAnalysisSettingsDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
