// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



/**
 * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
 */
class WaitAndContinueSpecification private constructor(builder: Builder) {
    /**
     * Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue responses for a slot aren't used. If the `active` field isn't specified, the default is true.
     */
    val active: kotlin.Boolean? = builder.active
    /**
     * The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
     */
    val continueResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.continueResponse
    /**
     * A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
     */
    val stillWaitingResponse: aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification? = builder.stillWaitingResponse
    /**
     * The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
     */
    val waitingResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = builder.waitingResponse

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WaitAndContinueSpecification(")
        append("active=$active,")
        append("continueResponse=$continueResponse,")
        append("stillWaitingResponse=$stillWaitingResponse,")
        append("waitingResponse=$waitingResponse)")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (continueResponse?.hashCode() ?: 0)
        result = 31 * result + (stillWaitingResponse?.hashCode() ?: 0)
        result = 31 * result + (waitingResponse?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WaitAndContinueSpecification

        if (active != other.active) return false
        if (continueResponse != other.continueResponse) return false
        if (stillWaitingResponse != other.stillWaitingResponse) return false
        if (waitingResponse != other.waitingResponse) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue responses for a slot aren't used. If the `active` field isn't specified, the default is true.
         */
        var active: kotlin.Boolean? = null
        /**
         * The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
         */
        var continueResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null
        /**
         * A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
         */
        var stillWaitingResponse: aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification? = null
        /**
         * The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
         */
        var waitingResponse: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification) : this() {
            this.active = x.active
            this.continueResponse = x.continueResponse
            this.stillWaitingResponse = x.stillWaitingResponse
            this.waitingResponse = x.waitingResponse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.WaitAndContinueSpecification = WaitAndContinueSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        fun continueResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.continueResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification] inside the given [block]
         */
        fun stillWaitingResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification.Builder.() -> kotlin.Unit) {
            this.stillWaitingResponse = aws.sdk.kotlin.services.lexmodelsv2.model.StillWaitingResponseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification] inside the given [block]
         */
        fun waitingResponse(block: aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.Builder.() -> kotlin.Unit) {
            this.waitingResponse = aws.sdk.kotlin.services.lexmodelsv2.model.ResponseSpecification.invoke(block)
        }
    }
}
