// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lexmodelsv2.model



class UpdateSlotRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the bot that contains the slot.
     */
    val botId: kotlin.String? = builder.botId
    /**
     * The version of the bot that contains the slot. Must always be `DRAFT`.
     */
    val botVersion: kotlin.String? = builder.botVersion
    /**
     * The new description for the slot.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the intent that contains the slot.
     */
    val intentId: kotlin.String? = builder.intentId
    /**
     * The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
     */
    val localeId: kotlin.String? = builder.localeId
    /**
     * Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to `true` in any other locale, Amazon Lex throws a `ValidationException`.
     *
     * If the `multipleValuesSetting` is not set, the default value is `false`.
     */
    val multipleValuesSetting: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting? = builder.multipleValuesSetting
    /**
     * New settings that determine how slot values are formatted in Amazon CloudWatch logs.
     */
    val obfuscationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting? = builder.obfuscationSetting
    /**
     * The unique identifier for the slot to update.
     */
    val slotId: kotlin.String? = builder.slotId
    /**
     * The new name for the slot.
     */
    val slotName: kotlin.String? = builder.slotName
    /**
     * The unique identifier of the new slot type to associate with this slot.
     */
    val slotTypeId: kotlin.String? = builder.slotTypeId
    /**
     * A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.
     */
    val valueElicitationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting? = builder.valueElicitationSetting

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSlotRequest(")
        append("botId=$botId,")
        append("botVersion=$botVersion,")
        append("description=$description,")
        append("intentId=$intentId,")
        append("localeId=$localeId,")
        append("multipleValuesSetting=$multipleValuesSetting,")
        append("obfuscationSetting=$obfuscationSetting,")
        append("slotId=$slotId,")
        append("slotName=$slotName,")
        append("slotTypeId=$slotTypeId,")
        append("valueElicitationSetting=$valueElicitationSetting)")
    }

    override fun hashCode(): kotlin.Int {
        var result = botId?.hashCode() ?: 0
        result = 31 * result + (botVersion?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (intentId?.hashCode() ?: 0)
        result = 31 * result + (localeId?.hashCode() ?: 0)
        result = 31 * result + (multipleValuesSetting?.hashCode() ?: 0)
        result = 31 * result + (obfuscationSetting?.hashCode() ?: 0)
        result = 31 * result + (slotId?.hashCode() ?: 0)
        result = 31 * result + (slotName?.hashCode() ?: 0)
        result = 31 * result + (slotTypeId?.hashCode() ?: 0)
        result = 31 * result + (valueElicitationSetting?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSlotRequest

        if (botId != other.botId) return false
        if (botVersion != other.botVersion) return false
        if (description != other.description) return false
        if (intentId != other.intentId) return false
        if (localeId != other.localeId) return false
        if (multipleValuesSetting != other.multipleValuesSetting) return false
        if (obfuscationSetting != other.obfuscationSetting) return false
        if (slotId != other.slotId) return false
        if (slotName != other.slotName) return false
        if (slotTypeId != other.slotTypeId) return false
        if (valueElicitationSetting != other.valueElicitationSetting) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier of the bot that contains the slot.
         */
        var botId: kotlin.String? = null
        /**
         * The version of the bot that contains the slot. Must always be `DRAFT`.
         */
        var botVersion: kotlin.String? = null
        /**
         * The new description for the slot.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the intent that contains the slot.
         */
        var intentId: kotlin.String? = null
        /**
         * The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see [Supported languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
         */
        var localeId: kotlin.String? = null
        /**
         * Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to `true` in any other locale, Amazon Lex throws a `ValidationException`.
         *
         * If the `multipleValuesSetting` is not set, the default value is `false`.
         */
        var multipleValuesSetting: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting? = null
        /**
         * New settings that determine how slot values are formatted in Amazon CloudWatch logs.
         */
        var obfuscationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting? = null
        /**
         * The unique identifier for the slot to update.
         */
        var slotId: kotlin.String? = null
        /**
         * The new name for the slot.
         */
        var slotName: kotlin.String? = null
        /**
         * The unique identifier of the new slot type to associate with this slot.
         */
        var slotTypeId: kotlin.String? = null
        /**
         * A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.
         */
        var valueElicitationSetting: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest) : this() {
            this.botId = x.botId
            this.botVersion = x.botVersion
            this.description = x.description
            this.intentId = x.intentId
            this.localeId = x.localeId
            this.multipleValuesSetting = x.multipleValuesSetting
            this.obfuscationSetting = x.obfuscationSetting
            this.slotId = x.slotId
            this.slotName = x.slotName
            this.slotTypeId = x.slotTypeId
            this.valueElicitationSetting = x.valueElicitationSetting
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lexmodelsv2.model.UpdateSlotRequest = UpdateSlotRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting] inside the given [block]
         */
        fun multipleValuesSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting.Builder.() -> kotlin.Unit) {
            this.multipleValuesSetting = aws.sdk.kotlin.services.lexmodelsv2.model.MultipleValuesSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting] inside the given [block]
         */
        fun obfuscationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting.Builder.() -> kotlin.Unit) {
            this.obfuscationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.ObfuscationSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting] inside the given [block]
         */
        fun valueElicitationSetting(block: aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting.Builder.() -> kotlin.Unit) {
            this.valueElicitationSetting = aws.sdk.kotlin.services.lexmodelsv2.model.SlotValueElicitationSetting.invoke(block)
        }
    }
}
